% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverlapFunctions.R
\name{overlapTypes}
\alias{overlapTypes}
\title{Annotate introns and exonic parts by overlaping exon biotype}
\usage{
overlapTypes(queryCoords, gtf, set = c("from", "to", "overlap"))
}
\arguments{
\item{queryCoords}{GRanges object of the query regions}

\item{gtf}{GRanges object of the GTF annotated with exon biotypes - i.e. exon, CDS, UTR}

\item{set}{which overlapping set of exon biotypes to return - to, from, and/or overlap}
}
\value{
overlaping types in a data.frame
}
\description{
Annotate introns and exonic parts by overlaping exon biotype
}
\examples{
gtfFile <- system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools")
DEXSeqGtfFile <- system.file("extdata","gencode.vM14.dexseq.gtf",
package = "GeneStructureTools")

gtf <- rtracklayer::import(gtfFile)
gtf <- UTR2UTR53(gtf)
DEXSeqGtf <- rtracklayer::import(DEXSeqGtfFile)

overlapTypes(DEXSeqGtf[1:10], gtf)
}
\author{
Beth Signal
}
