% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWhippetFiles.R
\name{formatWhippetEvents}
\alias{formatWhippetEvents}
\title{Format Whippet co-ordinates as a GRanges object}
\usage{
formatWhippetEvents(whippet)
}
\arguments{
\item{whippet}{data.frame containing event location information.
May be generated by readWhippetDIFFfiles()}
}
\value{
GRanges object with events
}
\description{
Format Whippet co-ordinates as a GRanges object
}
\examples{
whippetFiles <- list.files(system.file("extdata","whippet/",
package = "GeneStructureTools"), full.names = TRUE)
diffFiles <- whippetFiles[grep(".diff", whippetFiles)]
whippetDiffSplice <- readWhippetDIFFfiles(diffFiles)
whippetCoords <- formatWhippetEvents(whippetDiffSplice)
}
\seealso{
Other whippet data processing: \code{\link{coordinates}},
  \code{\link{diffSplicingResults}},
  \code{\link{filterWhippetEvents}},
  \code{\link{junctions}}, \code{\link{readCounts}},
  \code{\link{readWhippetDIFFfiles}},
  \code{\link{readWhippetDataSet}},
  \code{\link{readWhippetJNCfiles}},
  \code{\link{readWhippetPSIfiles}},
  \code{\link{whippetTranscriptChangeSummary}}
}
\author{
Beth Signal
}
