% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverlapFunctions.R
\name{DEXSeqIdsToGeneIds}
\alias{DEXSeqIdsToGeneIds}
\title{Convert DEXSeq ids to gene ids}
\usage{
DEXSeqIdsToGeneIds(DEXSeqIds, removeVersion = FALSE, containsE = TRUE)
}
\arguments{
\item{DEXSeqIds}{vector of DEXSeq group or exon ids}

\item{removeVersion}{remove the version (.xx) of the gene?}

\item{containsE}{do the DEXSeq exons ids contain :E00X?}
}
\value{
vector of unique gene ids
}
\description{
Convert DEXSeq ids to gene ids
}
\examples{
# multiple genes in name
DEXSeqId <- "ENSMUSG00000027618.17+ENSMUSG00000098950.7+ENSMUSG00000089824.10+ENSMUSG00000074643.12"
DEXSeqIdsToGeneIds(DEXSeqId)

# exonic part number in id
DEXSeqIdsToGeneIds("ENSMUSG00000001017.15:E013", removeVersion=TRUE)
}
\seealso{
Other DEXSeq processing methods: \code{\link{findDEXexonType}},
  \code{\link{summariseExonTypes}}
}
\author{
Beth Signal
}
