% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportNetwork.R
\name{exportNetwork}
\alias{exportNetwork}
\title{Save network in various formats}
\usage{
exportNetwork(network, file, format = c("HTML", "json", "XGMML"), ...)
}
\arguments{
\item{network}{output of \link{browseNetwork}}

\item{file}{Name of the file to save to.}

\item{format}{type in which graph shall be saved. 
Could be one of HTML, json or XGMML.}

\item{...}{Parameter could be used by \link[htmlwidgets]{saveWidget} for HTML
or writeLines for json or \link[XML]{saveXML} for XGMML.}
}
\description{
Save graph into HTML, json or xgmml format.
}
\examples{
data("ce.miRNA.map")
data("example.data")
data("ce.interactionmap")
data("ce.IDsMap")
sifNetwork<-buildNetwork(example.data$ce.bind, ce.interactionmap, level=2)
cifNetwork<-filterNetwork(rootgene=ce.IDsMap["DAF-16"], sifNetwork=sifNetwork, 
  exprsData=uniqueExprsData(example.data$ce.exprData, "Max", condenseName='logFC'),
  mergeBy="symbols",
  miRNAlist=as.character(ce.miRNA.map[ , 1]), tolerance=1)
gR<-polishNetwork(cifNetwork)
network <- browseNetwork(gR)
exportNetwork(network, "sample.html")
}
\keyword{IO}
