% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRLs.R
\name{getRLs}
\alias{getRLs}
\title{Convert gene expression profiles to a ranked list}
\usage{
getRLs(control, treatment)
}
\arguments{
\item{control}{a matrix, including the vehicle control gene expression
profiles corresponding to the treatment gene expression profiles.}

\item{treatment}{a matrix, is composed of gene expression profiles.}
}
\value{
A matrix is composed of ranked lists, a ranked list represents the
corresponding gene expression profiles.
}
\description{
Sorting the micro-array probe-set identifiers according to the differential
expression values with respect to the untreated hybridization to obtain a
ranked list. Gene-expression profiles in are represented in a nonparametric
fashion.
}
\details{
The genes on the array are rank-ordered according to their
differential expression relative to the control. First, control and
treatment values less than a primary threshold value (quartile) were set to
that threshold value. Finally, probe sets were ranked in descending order of
d, where d is the ratio of the corresponding treatment-to-control values.
For probe sets where d=1, a lower threshold was applied to the original
difference values and a new treatment to control ratio (d') calculated.
These probe sets were then sub-sorted in descending order of d.
}
\examples{
if (require(GEOquery)){
  # treatment gene-expression profiles
  file1 <- system.file(
    "extdata/GSM118720.soft",
    package = "GeneExpressionSignature"
  )
  GSM118720 <- getGEO(filename = file1)
  
  # control gene-expression profiles
  file2 <- system.file(
    "extdata/GSM118721.soft",
    package = "GeneExpressionSignature"
  )
  GSM118721 <- getGEO(filename = file2)
  
  # data ranking according to the different expression values 
  control <- as.matrix(as.numeric(Table(GSM118721)[, 2]))
  treatment <- as.matrix(as.numeric(Table(GSM118720)[, 2]))
  ranked_list <- getRLs(control, treatment)
}
}
