% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneViz.R
\name{geneViz}
\alias{geneViz}
\title{Construct a gene-features plot}
\usage{
geneViz(
  txdb,
  gr,
  genome,
  reduce = FALSE,
  gene_colour = NULL,
  base = c(10, 2, 2),
  transform = c("Intron", "CDS", "UTR"),
  isoformSel = NULL,
  labelTranscript = TRUE,
  labelTranscriptSize = 4,
  plotLayer = NULL
)
}
\arguments{
\item{txdb}{Object of class TxDb giving transcription meta data for a genome
assembly. See Bioconductor annotation packages.}

\item{gr}{Object of class GRanges specifying the region of interest and 
corresponding to a single gene. See Bioconductor package GRanges.}

\item{genome}{Object of class BSgenome specifying the genome sequence of
interest. See Bioconductor annotation packages.}

\item{reduce}{Boolean specifying whether to collapse gene isoforms within the
region of interest into one representative transcript. Experimental use with
caution!}

\item{gene_colour}{Character string specifying the colour of the gene to be
plotted.}

\item{base}{Numeric vector of log bases to transform the data
corresponding to the elements supplied to the variable transform See details.}

\item{transform}{Character vector specifying what objects to log transform,
accepts "Intron", "CDS", and "UTR" See details.}

\item{isoformSel}{Character vector specifying the names
(from the txdb object) of isoforms within the region of interest to display.}

\item{labelTranscript}{Boolean specifying whether to plot the transcript
names in the gene plot.}

\item{labelTranscriptSize}{Integer specifying the size of the transcript
name text in the gene plot.}

\item{plotLayer}{Valid ggplot2 layer to be added to the gene plot.}
}
\value{
object of class list with list elements containing a ggplot object, 
the gene features within the plot as a data frame, and mapping information
of the gene features within the ggplot object.
}
\description{
Given a GRanges object specifying a region of interest, plot genomic features
within that region.
}
\details{
geneViz is an internal function which will output a list of three
elements. As a convenience the function is exported however to obtain the
plot from geneViz the user must call the first element of the list. geneViz
is intended to plot gene features within a single gene with boundaries
specified by the GRanges object, plotting more that one gene is advised
against.

Typically, introns of a transcript are much larger than exons, while exons are
sometimes of greater interest. To address this, genCov will by default
scale the x-axis to expand track information according to region type: coding
sequence (CDS), untranslated region (UTR), or intron / intergenic (Intron).
The amount by which each region is scaled is controlled by the `base` and
`transform` arguments. `transform` specifies which regions to scale, and `base`
corresponds to the log base transform to apply to those regions. To keep one or
more region types from being scaled, omit the corresponding entries from the 
`base` and `transform` vectors.
}
\examples{
# need transcript data for reference
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene

# need a biostrings object for reference
library(BSgenome.Hsapiens.UCSC.hg19)
genome <- BSgenome.Hsapiens.UCSC.hg19

# need Granges object
gr <- GRanges(seqnames=c("chr10"),
ranges=IRanges(start=c(89622195), end=c(89729532)), strand=strand(c("+")))

# Plot the graphic
geneViz(txdb, gr, genome)
}
