% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compIdent.R
\name{compIdent}
\alias{compIdent}
\title{Construct identity snp comparison plot}
\usage{
compIdent(
  x,
  genome,
  target = NULL,
  debug = FALSE,
  mainLayer = NULL,
  covLayer = NULL,
  out = "plot"
)
}
\arguments{
\item{x}{data frame with rows representing samples and column names 
"sample_name", "bamfile". Columns should correspond to a sample name and a
bam file path.}

\item{genome}{Object of class BSgenome specifying the genome.}

\item{target}{Object of class data frame containing target locations in
1-base format and containing columns names "chr", "start", "end", "var",
"name". Columns should correspond to chromosome, start, end, variant allele, 
name of location.}

\item{debug}{Boolean specifying if test datasets should be used for
debugging.}

\item{mainLayer}{Valid ggplot2 layer for altering the main plot.}

\item{covLayer}{Valid ggplot2 layer for altering the coverage plot.}

\item{out}{Character vector specifying the the object to output, one of
"data", "grob", or "plot", defaults to "plot" (see returns).}
}
\value{
One of the following, a list of dataframes containing data to be
plotted, a grob object, or a plot.
}
\description{
Given the bam file path, count the number of reads at the 24 SNP locations
}
\details{
compIdent is a function designed to comppare samples via variant allele
frequencies (VAF) at specific sites. By default these sites correspond to 24
identity snps originating from the hg19 assembly however the user can specify
alternate sites via the target paramter. To view the 24 identity snp
locations use GenVisR::SNPloci.

Samples from the same origin are expected to have similar VAF values however
results can skew based on copy number alterations (CNA). The user is expected 
to  ensure no CNA occur at the 24 identity snp sites.

For display and debugging purposes a debug parameter is available which will
use predefined data instead of reading in bam files. Note that data in the
debug parameter is only available at the afore mentioned 24 sites.
}
\examples{
# Read in BSgenome object (hg19)
library(BSgenome.Hsapiens.UCSC.hg19)
hg19 <- BSgenome.Hsapiens.UCSC.hg19

# Generate plot
compIdent(genome=hg19, debug=TRUE)
}
