% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VEP-class.R
\docType{class}
\name{VEP-class}
\alias{VEP-class}
\alias{VEP}
\title{Class VEP}
\usage{
VEP(path, data = NULL, version = "auto", verbose = FALSE)
}
\arguments{
\item{path}{String specifying the path to a VEP annotation file. Can accept
wildcards if multiple VEP annotation files exist (see details).}

\item{data}{data.table object storing a GMS annotation file. Overrides "path"
if specified.}

\item{version}{String specifying the version of the VEP files, Defaults to
auto which will look for the version in the header.}

\item{verbose}{Boolean specifying if progress should be reported while
reading in the VEP files.}
}
\description{
An S4 class for Variant Effect Predictor input, under development!!!
}
\details{
When specifying a path to a VEP annotation file the option exist to
either specify the full path to an annotation file or to use wildcards to
specify multiple files. When specifying a full path the initalizer will check
if a column named "sample" containg the relevant sample for each row exists.
If such a column is not found the initalizer will assume this file
corresponds to only one sample and populate a sample column accordingly.
Alternatively if multiple files are specified at once using a wildcard, the
initalizer will aggregate all the files and use the file names minus any
extension to populate sample names.
}
\section{Slots}{

\describe{
\item{\code{path}}{Character string specifying the paths of the VEP files read in.}

\item{\code{version}}{Numeric value specifying the version of VEP used.}

\item{\code{vepObject}}{vep object which inherits from VEP_Virtual class.}
}}

\seealso{
\code{\link{Waterfall}}

\code{\link{MutSpectra}}
}
