% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMS-class.R
\docType{class}
\name{GMS-class}
\alias{GMS-class}
\alias{GMS}
\title{Class GMS}
\usage{
GMS(path, data = NULL, version = 4, verbose = FALSE)
}
\arguments{
\item{path}{String specifying the path to a GMS annotation file. Can accept
wildcards if multiple GMS annotation files exist (see details).}

\item{data}{data.table object storing a GMS annotation file. Overrides "path"
if specified.}

\item{version}{String specifying the version of the GMS files, Defaults to
version 4.}

\item{verbose}{Boolean specifying if progress should be reported while
reading in the GMS files.}
}
\description{
An S4 class for Genome Modeling System annotation files, under development!!!
}
\details{
When specifying a path to a GMS annotation file the option exist to
either specify the full path to an annotation file or to use wildcards to
specify multiple files. When specifying a full path the initalizer will check
if a column named "sample" containg the relevant sample for each row exists.
If such a column is not found the initalizer will assume this file
corresponds to only one sample and populate a sample column accordingly.
Alternatively if multiple files are specified at once using a wildcard, the
initalizer will aggregate all the files and use the file names minus any
extension top populate sample names.
The version defaults to 4 which is the default value of the GMS annotator.
This value will need to be changed only if files were created using a
different GMS annotator version.
}
\section{Slots}{

\describe{
\item{\code{path}}{Character string specifying the paths of the GMS files read in.}

\item{\code{version}}{Numeric value specifying the version of the GMS annotation files.}

\item{\code{gmsObject}}{gms object which inherits from gms_Virtual class.}
}}

\seealso{
\code{\link{Waterfall}}

\code{\link{MutSpectra}}
}
