% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pMM_Scoring.R
\name{getpMMMatrix}
\alias{getpMMMatrix}
\title{Calculate the pMM distance}
\usage{
getpMMMatrix(
  genesets,
  ppi,
  alpha = 1,
  progress = NULL,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{genesets}{a \code{list}, A \code{list} of genesets where each genesets is
represented by \code{list} of genes.}

\item{ppi}{a \code{data.frame}, Protein-protein interaction (PPI) network data
frame. The object is expected to have three columns, \code{Gene1} and
\code{Gene2} which specify the gene names of the interacting proteins
in no particular order (symmetric interaction) and a column
\code{combined_score} which is a numerical value of the strength of
the interaction.}

\item{alpha}{numeric, Scaling factor for controlling the influence of the
interaction score. Defaults to 1.}

\item{progress}{a \code{\link[shiny:Progress]{shiny::Progress()}} object, Optional progress bar object
to track the progress of the function (e.g. in a Shiny app).}

\item{BPPARAM}{A BiocParallel \code{bpparam} object specifying how parallelization
should be handled. Defaults to \code{\link[BiocParallel:SerialParam-class]{BiocParallel::SerialParam()}}}
}
\value{
A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} with pMM distance rounded to 2 decimal places.
}
\description{
Calculate the pMM distance of all combinations of genesets in a given data
set of genesets.
}
\examples{
## Mock example showing how the data should look like
genesets <- list(c("PDHB", "VARS2"), c("IARS2", "PDHA1"))

ppi <- data.frame(
  Gene1 = c("PDHB", "VARS2"),
  Gene2 = c("IARS2", "PDHA1"),
  combined_score = c(0.5, 0.2)
)

pMM <- getpMMMatrix(genesets, ppi)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
data(ppi_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())

pMM <- getpMMMatrix(genes, ppi)
}
\references{
See https://doi.org/10.1186/s12864-019-5738-6 for details on the original
implementation.
}
