% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_Graph.R
\name{getGraphTitle}
\alias{getGraphTitle}
\title{Build up the node title}
\usage{
getGraphTitle(
  geneset_df = NULL,
  node_ids,
  gs_ids,
  gs_names = NULL,
  cluster_id = NULL
)
}
\arguments{
\item{geneset_df}{A \code{data.frame} of genesets with a column \code{Genesets}
containing geneset identifiers and a column \code{Genes}
containing the genes belonging to each geneset}

\item{node_ids}{vector, a vector of ids of the nodes in the graph for
which the node title should be build.}

\item{gs_ids}{vector, a vector of geneset identifiers, e.g. the \code{Genesets}
column of \code{geneset_df}.}

\item{gs_names}{vector, a vector of geneset descriptions/names, e.g. the
\code{Term} / \code{Description} column of \code{geneset_df}.}

\item{cluster_id}{vector, a vector of cluster ids for each of the genesets}
}
\value{
A \code{list} of titles for a graph with nodes given by \code{node_ids}.
}
\description{
Build up the title for the graph nodes to display the available information
of each geneset.
}
\examples{
genes <- list(
  c("PDHB", "VARS2"), c("IARS2", "PDHA1"),
  c("AAAS", "ABCE1"), c("ABI1", "AAR2"), c("AATF", "AMFR"),
  c("BMS1", "DAP3"), c("AURKAIP1", "CHCHD1"), c("IARS2"),
  c("AHI1", "ALMS1")
)
gs_names <- c("a", "b", "c", "d", "e", "f", "g", "h", "i")
geneset_df <- data.frame(
  Genesets = gs_names,
  value = rep(1, 9)
)
geneset_df$Genes <- genes
graph <- getGraphTitle(
  geneset_df = geneset_df,
  node_ids = c(1:9),
  gs_ids = c(1:9),
  gs_names = gs_names
)

}
