% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_Graph.R
\name{getBipartiteGraph}
\alias{getBipartiteGraph}
\title{Construct a bipartite graph}
\usage{
getBipartiteGraph(cluster, gs_names, genes)
}
\arguments{
\item{cluster}{\code{list}, a \code{list} of clusters, cluster members are indicated by
numeric values.}

\item{gs_names}{vector, a vector of (geneset) identifiers/names to map the
numeric member value in \code{cluster} to.}

\item{genes}{\code{list}, a \code{list} of vectors of genenames which belong to the
genesets in \code{gs_names}.}
}
\value{
An \code{igraph} object to be further manipulated or processed/plotted
(e.g. via \code{\link[igraph:plot.igraph]{igraph::plot.igraph()}} or
\link[visNetwork:visNetwork-igraph]{visNetwork::visIgraph()})
}
\description{
Construct a bipartite graph from cluster information, mapping the cluster
to its members
}
\examples{
cluster <- list(c(1:5), c(6:9))
gs_names <- c("a", "b", "c", "d", "e", "f", "g", "h", "i")
genes <- list(
  c("PDHB", "VARS2"), c("IARS2", "PDHA1"),
  c("AAAS", "ABCE1"), c("ABI1", "AAR2"), c("AATF", "AMFR"),
  c("BMS1", "DAP3"), c("AURKAIP1", "CHCHD1"), c("IARS2"),
  c("AHI1", "ALMS1")
)

g <- getBipartiteGraph(cluster, gs_names, genes)
}
