% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_and_modules.R
\name{build_net}
\alias{build_net}
\title{Network building by co-expression score computation}
\usage{
build_net(
  data_expr,
  fit_cut_off = 0.9,
  cor_func = c("pearson", "spearman", "bicor", "other"),
  your_func = NULL,
  power_value = NULL,
  block_size = NULL,
  stop_if_fit_pb = FALSE,
  pct_power_ic = 0.7,
  network_type = c("unsigned", "signed", "signed hybrid"),
  tom_type = c("unsigned", "signed", "signed Nowick", "unsigned 2", "signed 2", "none"),
  keep_matrices = c("none", "cor", "adja", "both"),
  n_threads = NULL,
  ...
)
}
\arguments{
\item{data_expr}{matrix or data.frame or SummarizedExperiment, expression
data with genes as column and samples as row.}

\item{fit_cut_off}{float, cut off by which R^2 (coefficient of
determination) will be thresholded. Must be in ]0;1[.}

\item{cor_func}{string, name of the correlation function to be used. Must be
one of "pearson", "spearman", "bicor", "other". If "other", your_func must
be provided}

\item{your_func}{function returning correlation values. Final values must be
in [-1;1]}

\item{power_value}{integer, power to be applied to the adjacency matrix. If
NULL, will be estimated by trying different power law fitting.}

\item{block_size}{integer, size of blocks by which operations can be
proceed. Helping if working with low capacity computers. If null, will be
estimated.}

\item{stop_if_fit_pb}{boolean, does not finding a fit above fit_cut_off, or 
having a power too low or too high (based on WGCNA FAQ recommended powers)
should stop process, or just print a warning and return the highest fitting
power.}

\item{pct_power_ic}{float, confidence interval by which the power fitted
should be evaluated for too high or too low a power.}

\item{network_type}{string, type of network to be used. Either "unsigned",
"signed", "signed hybrid". See details.}

\item{tom_type}{string, type of the topological overlap matrix to be
computed. Either "none", "unsigned", "signed", "signed Nowick",
"unsigned 2", "signed 2" and "signed Nowick 2". See detail at
\code{\link[WGCNA]{TOMsimilarityFromExpr}}.}

\item{keep_matrices}{string, matrices to keep in final object. Can be one of
"none", "cor", "adja", "both". It is usefull to keep both if you plant to use
\code{\link{compare_conditions}}.}

\item{n_threads}{integer, number of threads that can be used to paralellise
the computing}

\item{...}{any other parameter compatible with
\code{\link{adjacency.fromSimilarity}}}
}
\value{
list containing network matrix, metadata of input parameters and
power fitting information.
}
\description{
Compute the adjacency matrix, then the TOM to build the network. Than detect
the modules by hierarchical clustering and thresholding
}
\examples{
net <- build_net(kuehne_expr[, seq_len(350)], n_threads = 1)

}
