% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSamples.R
\name{compareSamples}
\alias{compareSamples}
\title{Compare Samples using Fisher's exact test}
\usage{
compareSamples(
  df,
  col.count1,
  col.count2,
  total1,
  total2,
  multiAdjMethod = "BH",
  comparison.score = c("peak_score", "umi.count")
)
}
\arguments{
\item{df}{a data frame containing the peak score and sequence depth for each
sample}

\item{col.count1}{the score (e.g., peak_score) column used as the numerator
for calculating odds ratio. For example,if the tenth column contains the score
for sample 1, then set col.count1 = 10}

\item{col.count2}{the score (e.g., peak_score) column used as the denominator
for calculating odds ratio. For example,if the nineteenth column contains the score
for sample 1, then set col.count2 = 19}

\item{total1}{the sequence depth for sample 1}

\item{total2}{the sequence depth for sample 2}

\item{multiAdjMethod}{A vector of character strings containing the names of
the multiple testing procedures for which adjusted p-values are to be
computed. This vector should include any of the following:
"none", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BH", "BY",
"ABH", and "TSBH". Please type ?multtest::mt.rawp2adjp for details.
Default to "BH"}

\item{comparison.score}{the score to be used for statistical analysis.
Two options are available: "peak_score" and "umi.count"
umi.count is the number of unique UMIs in the associated peak region
without considering the sequence coordinates while peak_score takes
into consideration of the sequence coordinates}
}
\description{
Compare Samples using Fisher's exact test
}
\author{
Lihua Julie Zhu
}
