% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{evalNrSigSets}
\alias{evalNrSigSets}
\alias{evalNrSets}
\title{Evaluating gene set rankings for the number of (significant) sets}
\usage{
evalNrSigSets(ea.ranks, alpha = 0.05, padj = "none", perc = TRUE)

evalNrSets(ea.ranks, uniq.pval = TRUE, perc = TRUE)
}
\arguments{
\item{ea.ranks}{Enrichment analysis rankings.  A list with an entry for each
enrichment method applied.  Each entry is a list that stores for each
dataset analyzed the resulting gene set ranking as obtained from applying
the respective method to the respective dataset.}

\item{alpha}{Statistical significance level. Defaults to 0.05.}

\item{padj}{Character.  Method for adjusting p-values to multiple testing.
For available methods see the man page of the stats function
\code{\link{p.adjust}}.  Defaults to \code{"none"}.}

\item{perc}{Logical.  Should the percentage or absolute number of gene sets
be returned?  Percentage is typically more useful for comparison between
rankings with a potentially different total number of gene sets.  Defaults
to \code{TRUE}.}

\item{uniq.pval}{Logical.  Should the number of gene sets with a unique
p-value or the total number of gene sets per ranking be returned?  Defaults
to \code{TRUE}.}
}
\value{
A list of numeric vectors storing for each method the number of
(significant) gene sets for each dataset analyzed.  If each element of the
resulting list is of equal length (corresponds to successful application of
each enrichment method to each dataset), the list is automatically
simplified to a numeric matrix (rows = datasets, columns = methods).
}
\description{
These functions evaluate gene set rankings obtained from applying enrichment
methods to multiple datasets.  This allows to assess resulting rankings for
granularity (how many gene sets have a unique p-value?) and statistical
significance (how many gene sets have a p-value below a significance
threshold?).
}
\examples{

    # simulated setup:
    # 2 methods & 2 datasets
    methods <- paste0("m", 1:2)
    data.ids <- paste0("d", 1:2)

    # simulate gene set rankings
    getRankingForDataset <- function(d)
    {
         r <- EnrichmentBrowser::makeExampleData("ea.res") 
         EnrichmentBrowser::gsRanking(r, signif.only=FALSE)
    }
  
    getRankingsForMethod <- function(m)
    {
         rs <- lapply(data.ids, getRankingForDataset)
         names(rs) <- data.ids
         rs
    }
        
    ea.ranks <- lapply(methods, getRankingsForMethod) 
    names(ea.ranks) <- methods 

    # evaluate
    evalNrSets(ea.ranks)
    evalNrSigSets(ea.ranks)

}
\seealso{
\code{\link{runEA}} to apply enrichment methods to multiple
datasets; \code{\link{readResults}} to read saved rankings as an input for
the eval-functions.
}
\author{
Ludwig Geistlinger <Ludwig.Geistlinger@sph.cuny.edu>
}
