#' Simulated dose-response assay data (Case A)
#'
#' This is an example dataset corresponding to Case A.
#' The data was generated by the python script "generate_data.py" found in
#' the "inst/scripts/" directory.
#' This object is meant to be used as the "inputData" argument for the
#' \code{\link{GRfit}}
#' function when "case" is equal to "A" (the default option).
#' The input data for "Case A" of the \code{\link{GRfit}} function must be in
#' this format with columns named "concentration", "cell_count",
#' "cell_count__ctrl", and "cell_count__time0" as well as columns for other key
#' variables. The columns "cell_line", "agent", "perturbation", "replicate",
#' and "time" are simply examples of these key variables. It is not necessary
#' that your input data frame include these exact column names or the same
#' number of columns.
#'
#'
#' @format A data frame with 1008 rows and 9 variables:
#' \itemize{
#'   \item cell_line: the cell-line used (MCF10A, MCF7, BT20)
#'   \item agent: the drug used (drugA, drugB, drugC, drugD)
#'   \item pertubation: an example of another key variable (e.g different
#'   media, a co-treatment, etc.) (0, 1)
#'   \item replicate: replicate number, (1, 2, 3)
#'   \item time: time of assay measured in hours (48, 72)
#'   \item concentration: concentration of the perturbagen on which
#'   dose-response curves will be evaluated (not log transformed)
#'   \item cell_count: the measure of cell number (or a surrogate of cell
#'   number) after treatment at the end of the assay
#'   \item cell_count__ctrl: the measure of cell number in control
#'   (e.g. untreated or DMSO-treated) wells from the same plate at the end of
#'   the assay
#'   \item cell_count__time0: the measure of cell number in untreated wells
#'   grown in parallel until the time of treatment
#' }
#' @return An example dataset in the form of "Case A" generated for use with
#' \code{\link{GRfit}}
#' @source /inst/scripts/generate_data.py
"inputCaseA"

#' Simulated dose-response assay data (Case C)
#'
#' This is an example dataset corresponding to Case C.
#' The dataset is equivalent to that of Case A, but in a different form.
#' The data was generated by the python script "generate_data.py" found in
#' the "inst/scripts/" directory.
#' This object is meant to be used as the "inputData" argument for
#' the \code{\link{GRfit}} function when "case" is equal to "C".
#' The input data for "Case C" of the \code{\link{GRfit}} function must be in
#' this format with columns named "concentration", "cell_count",
#' and "time" as well as columns for other key
#' variables. The columns "cell_line", "agent", "perturbation", and
#' "replicate", are simply examples of these key variables. It is not necessary
#' that your input data frame include these exact column names or the same
#' number of columns.
#'
#'
#' @format A data frame with 1352 rows and 7 variables:
#' \itemize{
#'   \item cell_line: the cell-line used (MCF10A, MCF7, BT20)
#'   \item agent: the drug used (-, drugA, drugB, drugC, drugD)
#'   \item pertubation: an example of another key variable (e.g different
#'   media, a co-treatment, etc.) (0, 1)
#'   \item replicate: replicate number, (1, 2, 3)
#'   \item time: time of assay measured in hours (0, 48, 72)
#'   \item concentration: concentration of the perturbagen on which
#'   dose-response curves will be evaluated (not log transformed)
#'   \item cell_count: measure of cell number or a surrogate of the number
#'   of cells.
#' }
#' @return An example dataset in the form of "Case C" generated for use with
#' \code{\link{GRfit}}
#' @source inst/scripts/generate_data.py
"inputCaseC"
