% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotCommunitiesEnrichment}
\alias{plotCommunitiesEnrichment}
\title{Plot community-based enrichment results for a filtered \code{\linkS4class{GRN}} object}
\usage{
plotCommunitiesEnrichment(
  GRN,
  outputFolder = NULL,
  basenameOutput = NULL,
  selection = "byRank",
  communities = NULL,
  topn_pvalue = 30,
  p = 0.05,
  nSignificant = 2,
  nID = 10,
  maxWidth_nchar_plot = 50,
  display_pAdj = FALSE,
  plotAsPDF = TRUE,
  pdf_width = 12,
  pdf_height = 12,
  pages = NULL,
  forceRerun = FALSE
)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{outputFolder}{Character or \code{NULL}. Default \code{NULL}. If set to \code{NULL}, the default output folder as specified when initiating the 
object in \code{\link{initializeGRN}} will be used. Otherwise, all output from this function will be put into the specified folder. 
If a folder is provided, while we recommend specifying an absolute path, a relative one also works.}

\item{basenameOutput}{\code{NULL} or character. Default \code{NULL}. Basename of the output files that are produced. If set to \code{NULL}, a default basename is chosen. If a custom basename is specified, all output files will have the chosen basename as file prefix, be careful with not overwriting already existing files (if \code{forceRerun} is set to \code{TRUE})}

\item{selection}{Character. Default \code{"byRank"}. One of: \code{"byRank"}, \code{"byLabel"}. 
Specify whether the communities will be selected based on their rank or explicitly by their label. 
Note that the label is independent of the rank. When set to \code{"byRank"}, the largest 
community (with most vertices) always has a rank of 1.}

\item{communities}{\code{NULL} or numeric vector or character vector. Default \code{NULL}. 
If set to \code{NULL}, all community enrichments that have been calculated before are plotted. 
If a numeric vector is specified (when \code{selection = "byRank"}), the rank of the communities is specified.
For example, \code{communities = c(1,4)} then denotes the first and fourth largest community.
If a character vector is specified (when \code{selection = "byLabel"}), the name of the communities is specified instead.
For example, \code{communities = c("1","4")} then denotes the communities with the names "1" and "4", which may or may not be the largest and fourth largest communities among all.}

\item{topn_pvalue}{Numeric. Default 30. Maximum number of ontology terms that meet the p-value significance threshold to display in the enrichment dot plot}

\item{p}{Numeric. Default 0.05. p-value threshold to determine significance.}

\item{nSignificant}{Numeric > 0. Default 3. Threshold to filter out an ontology term with less than \code{nSignificant} overlapping genes.}

\item{nID}{Numeric > 0. Default 10. For the reduced summary heatmap, number of top terms to select per community / for the general enrichment.}

\item{maxWidth_nchar_plot}{Integer (>=10). Default 50. Maximum number of characters for a term before it is truncated.}

\item{display_pAdj}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Is the p-value being displayed in the plots the adjusted p-value? This parameter is relevant for KEGG, Disease Ontology, and Reactome enrichments, and does not affect GO enrichments.}

\item{plotAsPDF}{\code{TRUE} or \code{FALSE}. Default \code{TRUE}.Should the plots be printed to a PDF file? If set to \code{TRUE}, a PDF file is generated, the name of which depends on the value of \code{basenameOutput}. If set to \code{FALSE}, all plots are printed to the currently active device. Note that most functions print more than one plot, which means you may only see the last plot depending on your active graphics device.}

\item{pdf_width}{Number>0. Default 12. Width of the PDF, in cm.}

\item{pdf_height}{Number >0. Default 12. Height of the PDF, in cm.}

\item{pages}{Integer vector or \code{NULL}. Default \code{NULL}. Page number(s) to plot. Can be used to plot only specific pages to a PDF or the currently active graphics device.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}
}
\value{
The same \code{\linkS4class{GRN}} object, without modifications.
}
\description{
Similarly to \code{\link{plotGeneralEnrichment}} and \code{\link{plotTFEnrichment}}, the results of the community-based enrichment analysis are plotted.
This function produces multiple plots. First, one plot per community to summarize the community-specific enrichment.
Second, a summary heatmap of all significantly enriched terms across all communities and for the whole eGRN. The latter allows to compare the results with the general network enrichment.
Third, a subset of the aforementioned heatmap, showing only the top most significantly enriched terms per community and for the whole eGRN (as specified by \code{nID}) for improved visibility
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
GRN = plotCommunitiesEnrichment(GRN, plotAsPDF = FALSE, pages = 1)
}
\seealso{
\code{\link{plotGeneralEnrichment}}

\code{\link{plotTFEnrichment}}

\code{\link{calculateCommunitiesEnrichment}}
}
