% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{getParameters}
\alias{getParameters}
\title{Retrieve parameters for previously used function calls and general parameters for a \code{\linkS4class{GRN}} object.}
\usage{
getParameters(GRN, type = "parameter", name = "all")
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{type}{Character. Either \code{function} or \code{parameter}. Default \code{parameter}. When set to \code{function}, a valid \code{GRaNIE} function name must be given that has been run before. When set to \code{parameter}, in combination with \code{name}, returns a specific parameter (as specified in \code{GRN@config})).}

\item{name}{Character. Default \code{all}. Name of parameter or function name to retrieve. Set to the special keyword \code{all} to retrieve all parameters.}
}
\value{
The requested parameters. This function does **NOT** return a \code{\linkS4class{GRN}} object.
}
\description{
\strong{Note: This function, as all \code{get} functions from this package, does NOT return a \code{\linkS4class{GRN}} object.}
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
params.l = getParameters(GRN, type = "parameter", name = "all")
}
