% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{calculateCommunitiesStats}
\alias{calculateCommunitiesStats}
\title{Generate graph communities and their summarizing statistics}
\usage{
calculateCommunitiesStats(GRN, clustering = "louvain", forceRerun = FALSE, ...)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{clustering}{Character. Default \code{louvain}. One of: \code{louvain}, \code{leiden}, \code{leading_eigen}, \code{fast_greedy}, \code{optimal}, \code{walktrap}. The community detection algorithm to be used. Please bear in mind the robustness and time consumption of the algorithms when opting for an alternative to the default.}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}

\item{...}{Additional parameters for the used clustering method, see the \code{igraph::cluster_*} methods for details on the specific parameters and what they do. For \code{leiden} clustering, for example, you may add a \code{resolution_parameter} to control the granularity of the community detection or \code{n_iterations} to modify the number of iterations.}
}
\value{
An updated \code{\linkS4class{GRN}} object, with a table that consists of the connections clustered into communities stored in the 
\code{GRN@graph$TF_gene$clusterGraph} slot as well as within the \code{igraph} object in \code{GRN@graph$TF_gene$graph} (retrievable via \code{igraph} using \code{igraph::vertex.attributes(GRN@graph$TF_gene$graph)$community}, for example.)
}
\description{
The results can subsequently be visualized with the function \code{\link{plotCommunitiesStats}}
This function requires a filtered set of connections in the \code{\linkS4class{GRN}} object as generated by \code{\link{filterGRNAndConnectGenes}}.
It then generates the TF-gene graph from the filtered connections, and clusters its vertices into communities using established community detection algorithms.
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
GRN = calculateCommunitiesStats(GRN, forceRerun = FALSE)
}
\seealso{
\code{\link{plotCommunitiesStats}}

\code{\link{calculateCommunitiesEnrichment}}
}
