% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{build_eGRN_graph}
\alias{build_eGRN_graph}
\title{Builds a graph out of a set of connections}
\usage{
build_eGRN_graph(
  GRN,
  model_TF_gene_nodes_separately = FALSE,
  allowLoops = FALSE,
  removeMultiple = FALSE,
  directed = FALSE,
  forceRerun = FALSE
)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{model_TF_gene_nodes_separately}{\code{TRUE} or \code{FALSE}.  Default \code{FALSE}. Should TF and gene nodes be modeled separately? If set to \code{TRUE},this may lead to unwanted effects in case of TF-TF connections (i.e., a TF regulating another TF)}

\item{allowLoops}{\code{TRUE} or \code{FALSE}.  Default \code{FALSE}. Allow loops in the network (i.e., a TF that regulates itself)}

\item{removeMultiple}{\code{TRUE} or \code{FALSE}.  Default \code{FALSE}. Remove loops with the same start and end point? This can happen if multiple TF originate from the same gene, for example.}

\item{directed}{\code{TRUE} or \code{FALSE}.  Default \code{FALSE}. Should the network be directed?}

\item{forceRerun}{\code{TRUE} or \code{FALSE}. Default \code{FALSE}. Force execution, even if the GRN object already contains the result. Overwrites the old results.}
}
\value{
An updated \code{\linkS4class{GRN}} object, with the graph(s) being stored in the slot `graph` (i.e., `GRN@graph` for both TF-gene and TF-peak-gene graphs)
}
\description{
This function requires a filtered set of connections in the \code{\linkS4class{GRN}} object as generated by \code{\link{filterGRNAndConnectGenes}}
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
GRN = build_eGRN_graph(GRN, forceRerun = FALSE)
}
\seealso{
\code{\link{filterGRNAndConnectGenes}}
}
