% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgoSim.R
\name{mgoSim}
\alias{mgoSim}
\title{Semantic similarity between two GO term sets}
\usage{
mgoSim(GO1, GO2, semData, measure = "Wang", combine = "BMA")
}
\arguments{
\item{GO1}{A set of GO terms}

\item{GO2}{Another set of GO terms}

\item{semData}{GOSemSimDATA object}

\item{measure}{One of "Resnik", "Lin", "Rel", "Jiang", "TCSS" and "Wang" methods.}

\item{combine}{One of "max", "avg", "rcmax", "BMA" methods, used to combine multiple term scores.}
}
\value{
similarity
}
\description{
Given two sets of GO terms, calculate their semantic similarity.
}
\examples{
d <- godata('org.Hs.eg.db', ont = "MF", computeIC = FALSE)
go1 <- c("GO:0004022", "GO:0004024", "GO:0004023")
go2 <- c("GO:0009055", "GO:0020037")
mgoSim("GO:0003824", go2, semData = d, measure = "Wang")
mgoSim(go1, go2, semData = d, measure = "Wang")
}
\seealso{
\code{\link[=goSim]{goSim()}} \code{\link[=mgoSim]{mgoSim()}} \code{\link[=geneSim]{geneSim()}} \code{\link[=mgeneSim]{mgeneSim()}} \code{\link[=clusterSim]{clusterSim()}} \code{\link[=mclusterSim]{mclusterSim()}}
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
