% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSim.R
\name{geneSim}
\alias{geneSim}
\title{Semantic similarity between two genes}
\usage{
geneSim(gene1, gene2, semData, measure = "Wang", drop = "IEA", combine = "BMA")
}
\arguments{
\item{gene1}{Entrez gene ID}

\item{gene2}{Another Entrez gene ID}

\item{semData}{GOSemSimDATA object}

\item{measure}{One of "Resnik", "Lin", "Rel", "Jiang", "TCSS" and "Wang" methods.}

\item{drop}{Evidence codes to drop; use \code{NULL} to keep all GO annotations}

\item{combine}{One of "max", "avg", "rcmax", "BMA" methods, used to combine multiple term scores.}
}
\value{
A list containing similarity value and corresponding GO terms
}
\description{
Given two genes, calculate their semantic similarity and return the score with corresponding GO terms.
}
\examples{
d <- godata('org.Hs.eg.db', ont = "MF", computeIC = FALSE)
geneSim("241", "251", semData = d, measure = "Wang")
}
\seealso{
\code{\link[=goSim]{goSim()}} \code{\link[=mgoSim]{mgoSim()}} \code{\link[=mgeneSim]{mgeneSim()}} \code{\link[=clusterSim]{clusterSim()}} \code{\link[=mclusterSim]{mclusterSim()}}
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
