% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_module.R
\name{build_moduleR_heuristic}
\alias{build_moduleR_heuristic}
\title{Build regression tree with splits are detemined by K-means heuristicly.}
\usage{
build_moduleR_heuristic(
  X,
  Y,
  max_depth,
  cor_cutoff,
  min_divide_size,
  split_table
)
}
\arguments{
\item{X}{A n by p matrix as input.}

\item{Y}{A n by q matrix as response.}

\item{max_depth}{Maximum depth of the tree.}

\item{cor_cutoff}{Cutoff for within group Pearson correlation coefficient, if all data belong to 
a node have average correlation greater or equal to this, the node would not split anymore.}

\item{min_divide_size}{Minimum number of data belong to a node allowed for further split of the node.}

\item{split_table}{split table generated by K-means with build_split_table()}
}
\value{
A matrix for sample informatrion for each tree level. First column is feature index used by the 
node and second is the value used to split, 
the rest of the columns are the split of sample: 0 means less or equal, 1 means greater and -1 
means the sample does not belong to this node.
}
\description{
Build regression tree based on Gaussian Likelihood score. The spliting of the tree is determined heuristicly by k_means.
}
\examples{
X <- matrix(rnorm(5*10),5,10)
build_moduleR_heuristic(X = X, Y = matrix(rnorm(5*10),5,10),max_depth=3,cor_cutoff=0.9,
                        min_divide_size=3,split_table = build_split_table(X))
}
