% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRnaQuantificationSet.R
\name{getRnaQuantificationSet}
\alias{getRnaQuantificationSet}
\title{getRnaQuantificationSet function}
\usage{
getRnaQuantificationSet(host, rnaQuantificationSetId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{rnaQuantificationSetId}{ID of the RNA quantification set requested.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get an RNA quantification set by its ID.
}
\details{
This function requests \code{GET host/rnaquantificationsets/rnaQuantificationSetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
rnaQuantificationSetId <- searchRnaQuantificationSets(host, datasetId, nrows = 1)$id
getRnaQuantificationSet(host, rnaQuantificationSetId)
}
}
\references{
\href{http://ga4gh-schemas.readthedocs.io/en/latest/schemas/rna_quantification_service.proto.html#GetRnaQuantificationSet}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchRnaQuantificationSets}}
}
