% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSNV.R
\name{checkSNV}
\alias{checkSNV}
\title{Check the validity of SNVs}
\usage{
checkSNV(snv_gr = NULL, mode = "wra", ref_col = NULL, alt_col = NULL)
}
\arguments{
\item{snv_gr}{A \code{GRanges} object containing SNV data.}

\item{mode}{A character string specifying the checks to be performed.
\code{w} for checking if all widths (w) are 1,
\code{r} for checking if all ref (r) values are A, T, C, or G,
\code{a} for checking if all alt (a) values are A, T, C, or G.}

\item{ref_col}{Column name for the ref bases in \code{snv_gr}.
Default is NULL.}

\item{alt_col}{Column name for the alt bases in \code{snv_gr}.
Default is NULL.}
}
\value{
A logical value indicating whether the user-provided SNVs
passed all checks.
}
\description{
This function is deprecated and will be removed in a future version.
}
\details{
This function checks whether the user-provided SNVs are single
nucleotide substitutions.
}
\section{Deprecated}{

This function is no longer supported.
}

\examples{

if (!requireNamespace("BiocManager", quietly = TRUE)) {
  install.packages("BiocManager")
}

if (!requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)) {
  BiocManager::install("GenomicRanges")
}

library(GenomicRanges)
gr1 <- GRanges("chr1", IRanges(start = 100, width = 1))
# check width ('w')
checkSNV(gr1, mode = "w")

gr2 <- GRanges(
  seqnames = Rle("seq1"),
  ranges = IRanges(c(100, 200, 300), width = 1),
  ref = c("A", "C", "G"),
  alt = c("T", "T", "A")
)

# check width ('w'), ref ('r'), and alt ('a')
checkSNV(gr2, mode = "wra", ref_col = "ref", alt_col = "alt")
# check width ('w') and alt ('a')
checkSNV(gr2, mode = "wa", alt_col = "alt")

gr3 <- GRanges("chr1", IRanges(start = 100, width = 10))
# widths should be all one
checkSNV(gr3, mode = "w")

gr4 <- GRanges(
  seqnames = Rle("seq1"),
  ranges = IRanges(start = 100, width = 1),
  ref = "AG",
  alt = "T"
)

# ref should be all one
checkSNV(gr4, mode = "wr", ref_col = "ref")
}
