% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_deprecated.R
\name{PlotNode}
\alias{PlotNode}
\title{PlotNode
Plot star chart}
\usage{
PlotNode(
  fsom,
  id,
  markers = fsom$map$colsUsed,
  colorPalette = grDevices::colorRampPalette(c("#00007F", "blue", "#007FFF", "cyan",
    "#7FFF7F", "yellow", "#FF7F00", "red", "#7F0000")),
  main = paste0("Cluster ", id)
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}} or
the first element of the list returned by 
\code{\link{FlowSOM}}}

\item{id}{Id of the node to plot (check PlotNumbers to get the ids)}

\item{markers}{Array of markers to use. Default: the markers used to build 
the tree}

\item{colorPalette}{Color palette to be used for the markers}

\item{main}{Title of the plot}
}
\value{
Nothing is returned. A plot is drawn in which the node is 
represented by a star chart indicating the median fluorescence intensities.
}
\description{
Plot a star chart indicating median marker values of a single node
}
\examples{
   # Read from file, build self-organizing map and minimal spanning tree
   fileName <- system.file("extdata", "68983.fcs", package="FlowSOM")
   flowSOM.res <- FlowSOM(fileName, compensate=TRUE,transform=TRUE,
                            scale=TRUE,colsToUse=c(9,12,14:18),nClus=10)
   
   # Deprecated, it is currently not possible anymore to plot an individual
   # node alone. If necessary, zooming in on a node can be approximated by
   # exagerating the size of the node.
   PlotStars(flowSOM.res, nodeSizes = c(100, rep(0,99)), maxNodeSize = 10)

}
\seealso{
\code{\link{PlotStars}},\code{\link{PlotNumbers}},
 \code{\link{FlowSOM}}
}
