% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_barcode.R
\name{plot_demultiplex_raw}
\alias{plot_demultiplex_raw}
\title{Plot Cell Barcode demultiplex statistics}
\usage{
plot_demultiplex_raw(find_barcode_result)
}
\arguments{
\item{find_barcode_result}{output from \code{\link{find_barcode}}}
}
\value{
a list of ggplot objects:
\itemize{
\item reads_count_plot: stacked barplot of: demultiplexed reads
\item knee_plot: knee plot of UMI counts before TSO trimming
\item flank_editdistance_plot: flanking sequence (adaptor) edit-distance plot
\item barcode_editdistance_plot: barcode edit-distance plot
\item cutadapt_plot: if TSO trimming is performed, number of reads kept by cutadapt
}
}
\description{
produce a barplot of cell barcode demultiplex statistics
}
\examples{
outdir <- tempfile()
dir.create(outdir)
fastq_dir <- tempfile()
dir.create(fastq_dir)
file.copy(system.file("extdata", "fastq", "musc_rps24.fastq.gz", package = "FLAMES"),
  file.path(fastq_dir, "musc_rps24.fastq.gz"))
sampled_lines <- readLines(file.path(fastq_dir, "musc_rps24.fastq.gz"), n = 400)
writeLines(sampled_lines, file.path(fastq_dir, "copy.fastq"))
bc_allow <- file.path(outdir, "bc_allow.tsv")
R.utils::gunzip(
  filename = system.file("extdata", "bc_allow.tsv.gz", package = "FLAMES"),
  destname = bc_allow, remove = FALSE
)
find_barcode(
  fastq = fastq_dir,
  stats_out = file.path(outdir, "bc_stat.tsv.gz"),
  reads_out = file.path(outdir, "demultiplexed.fq"),
  barcodes_file = bc_allow, TSO_seq = "CCCATGTACTCTGCGTTGATACCACTGCTT"
) |>
  plot_demultiplex_raw()
}
\keyword{internal}
