% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_decay.R
\name{convolution_filter}
\alias{convolution_filter}
\title{Convolution filter for smoothing transcript coverages}
\usage{
convolution_filter(x, threshold = 0.15, width = 2, trim = 0.05)
}
\arguments{
\item{x}{numeric vector of coverage values}

\item{threshold}{numeric, the threshold for the maximum absolute value of the
convolution}

\item{width}{numeric, the width of the 1s and -1s in the kernal. E.g. \code{width = 2}
will result in a kernal of \code{c(1, 1, -1, -1)}}

\item{trim}{numeric, the proportion of the coverage values to ignore at
both ends before convolution.}
}
\value{
logical, \code{TRUE} if the transcript passes the filter, \code{FALSE} otherwise
}
\description{
Filter out transcripts with sharp drops / rises in coverage,
to be used in \code{filter_coverage} to remove transcripts with potential
misalignments / internal priming etc. Filtering is done by convolving the
coverage with a kernal of 1s and -1s (e.g. \code{c(1, 1, -1, -1)}, where
the width of the 1s and -1s are determined by the \code{width} parameter),
and check if the maximum absolute value of the convolution is below a
threshold. If the convolution is below the threshold, \code{TRUE} is returned,
otherwise \code{FALSE}.
}
\examples{
# A >30\% drop in coverage will fail the filter with threshold = 0.3
convolution_filter(c(1, 1, 1, 0.69, 0.69, 0.69), threshold = 0.3)
convolution_filter(c(1, 1, 1, 0.71, 0.7, 0.7), threshold = 0.3)

}
