% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantification.R
\name{add_gene_counts}
\alias{add_gene_counts}
\title{Add gene counts to a \code{SingleCellExperiment} object}
\usage{
add_gene_counts(sce, gene_count_file)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object.}

\item{gene_count_file}{The file path to the gene count file. If missing,
the function will try to find the gene count file in the output directory.}
}
\value{
A \code{SingleCellExperiment} object with gene counts added.
}
\description{
Add gene counts to a \code{SingleCellExperiment} object
as an \code{altExps} slot named \code{gene}.
}
\examples{
# Set up a mock SingleCellExperiment object
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(counts = matrix(0, nrow = 10, ncol = 10))
)
colnames(sce) <- paste0("cell", 1:10)
# Set up a mock gene count file
gene_count_file <- tempfile()
gene_mtx <- matrix(1:10, nrow = 2, ncol = 5)
colnames(gene_mtx) <- paste0("cell", 1:5)
rownames(gene_mtx) <- c("gene1", "gene2")
write.csv(gene_mtx, gene_count_file)
# Add gene counts to the SingleCellExperiment object
sce <- add_gene_counts(sce, gene_count_file)
# verify the gene counts are added
SingleCellExperiment::altExps(sce)$gene
}
