% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_decay.R
\name{plot_coverage}
\alias{plot_coverage}
\title{plot read coverages}
\usage{
plot_coverage(
  x,
  quantiles = c(0, 0.2375, 0.475, 0.7125, 0.95, 1),
  length_bins = c(0, 1, 2, 5, 10, Inf),
  weight_fn = weight_transcripts,
  filter_fn,
  detailed = FALSE
)
}
\arguments{
\item{x, }{path to the BAM file (aligning reads to the transcriptome), or
the (GenomicAlignments::readGAlignments) parsed GAlignments object, or the
tibble returned by \code{\link{get_coverage}}, or the filtered tibble returned
by \code{\link{filter_coverage}}.}

\item{quantiles}{numeric vector to specify the quantiles to bin the transcripts lengths
by if length_bins is missing. The length bins will be determined such that the read
counts are distributed acording to the quantiles.}

\item{length_bins, }{numeric vector to specify the sizes to bin the transcripts by}

\item{weight_fn}{function to calculate the weights for the transcripts. The function
should take a numeric vector of read counts and return a numeric vector of weights.
The default function is \code{\link{weight_transcripts}}, you can change its default
parameters by passing an anonymous function like \code{function(x) weight_transcripts(x, type = 'equal')}.}

\item{filter_fn}{Optional filter function to filter the transcripts before plotting.
See the \code{filter_fn} parameter in \code{\link{filter_coverage}} for more details.
Providing a filter fucntion here is the same as providing it in \code{\link{filter_coverage}}
and then passing the result to this function.}

\item{detailed}{logical, if \code{TRUE}, also plot the top 10 transcripts with the highest
read counts for each length bin.}
}
\value{
a ggplot2 object of the coverage plot(s)
}
\description{
Plot the average read coverages for each length bin or a
perticular isoform
}
\examples{
ppl <- example_pipeline("BulkPipeline")
steps(ppl)["isoform_identification"] <- FALSE
ppl <- run_step(ppl, "read_realignment")
# Plot the coverages directly from the BAM file
plot_coverage(ppl@transcriptome_bam[[1]])

# Get the coverage information first
coverage <- get_coverage(ppl@transcriptome_bam[[1]]) |>
  dplyr::filter(read_counts > 2) |> # Filter out transcripts with read counts < 3
  filter_coverage(filter_fn = convolution_filter) # Filter out transcripts with sharp drops / rises
# Plot the filtered coverages
plot_coverage(coverage, detailed = TRUE)
# filtering function can also be passed directly to plot_coverage
plot_coverage(ppl@transcriptome_bam[[1]], filter_fn = convolution_filter)
}
