% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetParent}
\alias{subsetParent}
\alias{subsetParent,SubsetRangedSummarizedExperiment-method}
\alias{subsetParent,SubsetSingleCellExperiment-method}
\alias{subsetParent,SubsetSummarizedExperiment-method}
\alias{subsetParent,SubsetSpatialExperiment-method}
\alias{subsetParent,SubsetTreeSummarizedExperiment-method}
\title{Subset parent hierarchy retrieval method for ExperimentSubset objects}
\usage{
subsetParent(x, subsetName)

\S4method{subsetParent}{SubsetRangedSummarizedExperiment}(x, subsetName)

\S4method{subsetParent}{SubsetSingleCellExperiment}(x, subsetName)

\S4method{subsetParent}{SubsetSummarizedExperiment}(x, subsetName)

\S4method{subsetParent}{SubsetSpatialExperiment}(x, subsetName)

\S4method{subsetParent}{SubsetTreeSummarizedExperiment}(x, subsetName)
}
\arguments{
\item{x}{\code{ExperimentSubset} Input \code{ExperimentSubset} object.}

\item{subsetName}{\code{character(1)} Specify the name of the subset against
which the 'subset to parent link' should be retrieved.}
}
\value{
A \code{list} containing the 'subset to parent' link.
}
\description{
Retrieves a complete 'subset to parent' link from a specified
  subset.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es, "subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
assay(es, "subset1",
subsetAssayName = "subset1pAssay") <- assay(es, "subset1")[,] + 1
subsetParent(es, "subset1pAssay")
}
