% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetCount}
\alias{subsetCount}
\alias{subsetCount,SubsetRangedSummarizedExperiment-method}
\alias{subsetCount,SubsetSingleCellExperiment-method}
\alias{subsetCount,SubsetSummarizedExperiment-method}
\alias{subsetCount,SubsetSpatialExperiment-method}
\alias{subsetCount,SubsetTreeSummarizedExperiment-method}
\title{Subset count method for ExperimentSubset objects}
\usage{
subsetCount(x)

\S4method{subsetCount}{SubsetRangedSummarizedExperiment}(x)

\S4method{subsetCount}{SubsetSingleCellExperiment}(x)

\S4method{subsetCount}{SubsetSummarizedExperiment}(x)

\S4method{subsetCount}{SubsetSpatialExperiment}(x)

\S4method{subsetCount}{SubsetTreeSummarizedExperiment}(x)
}
\arguments{
\item{x}{\code{ExperimentSubset} Input \code{ExperimentSubset} object.}
}
\value{
A \code{numeric} value representing the total count of the subsets.
}
\description{
Get the total count of the available subsets (excluding subset
  assays) in an \code{ExperimentSubset} object.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
subsetCount(es)
}
