% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSI_Statistic.R
\name{PSI_Statistic}
\alias{PSI_Statistic}
\title{PSI_Statistic}
\usage{
PSI_Statistic(PSI, Design, Contrast, nboot)
}
\arguments{
\item{PSI}{A matrix with the values of the PSI.}

\item{Design}{The design matrix for the experiment.}

\item{Contrast}{The contrast matrix for the experiment.}

\item{nboot}{The number of random analysis.}
}
\value{
The output of these functions is a list containing: two data.frame (deltaPSI and Pvalues) with the values of the deltaPSI
 and the p.values for each contrast, and a third element (LocalFDR) with the information of the local false discovery rate.
}
\description{
Statistical analysis of the alternative splicing events. This function takes as input the values of PSI.
Perform a statistical analysis based on permutation test
}
\examples{
\dontrun{
      data(ArraysData)
      PSI_Arrays_list<-EventPointer:::getPSI(ArraysData)
      PSI_Arrays <- PSI_Arrays_list$PSI
      Design <- matrix(c(1,1,1,1,0,0,1,1),nrow=4)
      Contrast <- matrix(c(0,1),nrow=1)
      
      # Statistical analysis:
      
      table <- PSI_Statistic(PSI_Arrays,Design = Design, Contrast = Contrast, nboot = 50)
 }
      

}
