% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeEpiTxDb.R
\name{makeEpiTxDb}
\alias{makeEpiTxDb}
\title{Creating a \code{EpiTxDb} from user supplied annotations as
\code{data.frame}s}
\usage{
makeEpiTxDb(
  modifications,
  reactions = NULL,
  specifiers = NULL,
  references = NULL,
  metadata = NULL,
  reassign.ids = FALSE
)
}
\arguments{
\item{modifications}{A \code{data.frame} containg the following columns:
\itemize{
  \item \code{mod_id}: a unique \code{integer} value per modification.
  \item \code{mod_type}: the modification type as a \code{character} or
  \code{factor} value. Must be a value from
  \code{shortName(ModRNAString())}.
  \item \code{mod_name}: a \code{character} or \code{factor} name for the
  specific modification
  \item \code{mod_start}: the start position for the modification as
  \code{integer} value. Usually \code{mod_start = mod_end}
  \item \code{mod_end}: the end position for the modification as
  \code{integer} value. Usually \code{mod_start = mod_end}
  \item \code{mod_strand}: the strand information for the modificaion as a
  \code{character} or \code{factor}.
  \item \code{sn_id}: a \code{integer} value per unique sequence
  \item \code{sn_name}: a \code{character} or \code{factor} as sequence
  name, e.g a chromosome or a transcript identifier like \code{chr1}.
}
The first six are mandatory, whereas one of the last two has to be set.
\code{sn_id} will be generated from \code{sn_name}, if \code{sn_id} is not
set.}

\item{reactions}{An optional \code{data.frame} containg the following
columns:
\itemize{
  \item \code{mod_id}: a \code{integer} value per modification and the
  link to the \code{modification} \code{data.frame}.
  \item \code{rx_genename}: a \code{character} or \code{factor} referencing
  a genename for the enzyme incorporating the modification.
  \item \code{rx_rank}: a \code{integer} for sorting enzyme reactions, if
  multiple enzymes are involved in the modification's
  incorporation/maintenance.
  \item \code{rx_ensembl}: a \code{character} or \code{factor} with an
  ensembl identifier for the genename of the enzyme.
  \item \code{rx_ensembltrans}: a \code{character} or \code{factor} with an
  ensembl identifier for the transcript being translated into the enzyme.
  \item \code{rx_entrezid}: a \code{character} or \code{factor} with an
  entrezid for the genename of the enzyme.
}
(default: \code{reactions = NULL})}

\item{specifiers}{An optional \code{data.frame} containg the following
columns:
  \itemize{
  \item \code{mod_id}: a \code{integer} value per modification and the
  link to the \code{modification} \code{data.frame}.
  \item \code{spec_type}: a \code{character} or \code{factor}
  referencing a type of specifier, e.g. \code{snoRNA}. Not checked for
  validity.
  \item \code{spec_genename}: a \code{character} or \code{factor}
  referencing a genename for the specifier directing an enzyme to the
  specific location for the modification to be incorporated.
  \item \code{spec_ensembl}: a \code{character} or \code{factor} with an
  ensembl identifier for the genename of the specifier.
  \item \code{spec_ensembltrans}: a \code{character} or \code{factor} with an
  ensembl identifier for the transcript being translated into the specifier.
  \item \code{spec_entrezid}: a \code{character} or \code{factor} with an
  entrezid for the genename of the specifier.
}
(default: \code{specifiers = NULL})}

\item{references}{An optional \code{data.frame} containg the following
columns:
\itemize{
  \item \code{mod_id}: a \code{integer} value per modification and the
  link to the \code{modification} \code{data.frame}.
  \item \code{ref_type}: a \code{character} or \code{factor} with a
  reference type, e.g. \code{PMID}. Is not checked for validity.
  \item \code{ref}: a \code{character} or \code{factor} with a reference
  value, e.g. a specific pubmed id or an journal article. Is not checked
  for validity.
}
(default: \code{references = NULL})}

\item{metadata}{An optional \code{data.frame} containg the following columns:
\itemize{
  \item \code{name}: a \code{character} value used as name
  \item \code{value}: a \code{character} value
}
This dataframe will be returned
by \code{metadata()} (default: \code{metadata = NULL})}

\item{reassign.ids}{\code{TRUE} or \code{FALSE} Controls how internal
\code{mod_id}s should be assigned. If \code{reassign.ids} is \code{FALSE}
(the default) and if the ids are supplied, then they are used as the
internal ids, otherwise the internal ids are assigned in a way that is
compatible with the order defined by ordering the modifications first by
chromosome, then by strand, then by start, and finally by end.}
}
\value{
a \code{EpiTxDb} object.
}
\description{
\code{makeEpiTxDb} is a low-level constructor for creating a
\code{\link[=EpiTxDb-class]{EpiTxDb}} object from user supplied annotations.

This functions typically will not be used by regular users.
}
\examples{
mod <- data.frame("mod_id" = 1L,
                  "mod_type" = "m1A",
                  "mod_name" = "m1A_1",
                  "mod_start" = 1L,
                  "mod_end" = 1L,
                  "mod_strand" = "+",
                  "sn_id" = 1L,
                  "sn_name" = "test")
rx <- data.frame(mod_id = 1L,
                 rx_genename = "test",
                 rx_rank = 1L,
                 rx_ensembl = "test",
                 rx_ensembltrans = "test",
                 rx_entrezid = "test")
spec <- data.frame(mod_id = 1L,
                   spec_type = "test",
                   spec_genename = "test",
                   spec_ensembl = "test",
                   spec_ensembltrans = "test",
                   spec_entrezid = "test")
ref <- data.frame(mod_id = 1L,
                  ref_type = "test",
                  ref = "test")
etdb <- makeEpiTxDb(mod,rx,spec,ref)
}
\seealso{
\itemize{
  \item \code{\link[=makeEpiTxDbFromGRanges]{makeEpiTxDbFromGRanges}} for
    creating a \code{EpiTxDb} object from a
  \code{\link[GenomicRanges:GRanges-class]{GRanges}} object and it's metadata
    columns
  \item \code{\link[=makeEpiTxDbFromRMBase]{makeEpiTxDbFromRMBase}} for
    creating a \code{EpiTxDb} object from RMBase online resources
  \item \code{\link[=makeEpiTxDbFromtRNAdb]{makeEpiTxDbFromtRNAdb}} for
    creating a \code{EpiTxDb} object from tRNAdb online resources
  \item \code{\link[Modstrings:alphabet]{shortName}} and
  \code{\link[Modstrings:ModRNAString]{ModRNAString}} for information on
  \code{ModRNAString} objects.
}
}
