% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetNearbyGenes.R
\name{getFeatureProbe}
\alias{getFeatureProbe}
\title{getFeatureProbe to select probes within promoter regions or distal regions.}
\usage{
getFeatureProbe(
  feature = NULL,
  TSS,
  genome = "hg38",
  met.platform = "HM450",
  TSS.range = list(upstream = 2000, downstream = 2000),
  promoter = FALSE,
  rm.chr = NULL
)
}
\arguments{
\item{feature}{A GRange object containing biofeature coordinate such as
enhancer coordinates.
If NULL only distal probes (2Kbp away from TSS will be selected)
feature option is only usable when promoter option is FALSE.}

\item{TSS}{A GRange object contains the transcription start sites. When promoter is FALSE, Union.TSS
in \pkg{ELMER.data} will be used for default. When promoter is TRUE, UCSC gene TSS will
be used as default (see detail). User can specify their own preference TSS annotation.}

\item{genome}{Which genome build will be used: hg38 (default) or hg19.}

\item{met.platform}{DNA methyaltion platform to retrieve data from: EPIC or 450K (default)}

\item{TSS.range}{A list specify how to define promoter regions.
Default is upstream =2000bp and downstream=2000bp.}

\item{promoter}{A logical.If TRUE, function will ouput the promoter probes.
If FALSE, function will ouput the distal probes overlaping with features. The
default is FALSE.}

\item{rm.chr}{A vector of chromosome need to be remove from probes such as chrX chrY or chrM}
}
\value{
A GRange object containing probes that satisfy selecting critiria.
}
\description{
getFeatureProbe is a function to select the probes falling into
distal feature regions or promoter regions.

This function selects the probes on HM450K that either overlap
distal biofeatures or TSS promoter.
}
\details{
In order to get real distal probes, we use more comprehensive annotated TSS by both
 GENCODE and UCSC. However, to get probes within promoter regions need more
 accurate annotated TSS such as UCSC. Therefore, there are different settings for
 promoter and distal probe selection. But user can specify their own favorable
 TSS annotation. Then there won't be any difference between promoter and distal
 probe selection.
 @return A GRanges object contains the coordinate of probes which locate
 within promoter regions or distal feature regions such as union enhancer from REMC and FANTOM5.
 @usage getFeatureProbe(feature,
                          TSS,
                          TSS.range = list(upstream = 2000, downstream = 2000),
                          promoter = FALSE, rm.chr = NULL)
}
