% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadKEGGPathways.R
\name{downloadPathways}
\alias{downloadPathways}
\alias{download.kegg.pathways}
\title{Download of KEGG pathways for a particular organism}
\usage{
downloadPathways(org, cache = TRUE, out.dir = NULL, zip = FALSE)
}
\arguments{
\item{org}{Organism in KEGG three letter code, e.g. \sQuote{hsa} for
\sQuote{homo sapiens}.}

\item{cache}{Logical.  Should a locally cached version used if available?
Defaults to \code{TRUE}.}

\item{out.dir}{Output directory.  If not null, pathways are written to files
in the specified directory.}

\item{zip}{Logical.  In case pathways are written to file (\sQuote{out.dir}
is not null): should output files be zipped?}
}
\value{
if(is.null(out.dir)): a list of KEGGPathway objects else: none, as
pathways are written to file
}
\description{
The function downloads all metabolic and non-metabolic pathways in KEGG XML
format for a specified organism.
}
\examples{

    \donttest{
        pwys <- downloadPathways("hsa")
    }

}
\seealso{
\code{\link{keggList}}, \code{\link{keggGet}},
\code{\linkS4class{KEGGPathway}}, \code{\link{parseKGML}}
}
\author{
Ludwig Geistlinger
}
