% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnhancedVolcano.R
\name{EnhancedVolcano}
\alias{EnhancedVolcano}
\title{Publication-ready volcano plots with enhanced colouring and labeling.}
\usage{
EnhancedVolcano(
  toptable,
  lab,
  x,
  y,
  selectLab = NULL,
  xlim = c(min(toptable[[x]], na.rm = TRUE) - 1.5, max(toptable[[x]], na.rm = TRUE) +
    1.5),
  ylim = c(0, max(-log10(toptable[[y]]), na.rm = TRUE) + 5),
  xlab = bquote(~Log[2] ~ "fold change"),
  ylab = bquote(~-Log[10] ~ italic(P)),
  axisLabSize = 18,
  title = "Volcano plot",
  subtitle = bquote(italic(EnhancedVolcano)),
  caption = paste0("total = ", nrow(toptable), " variables"),
  titleLabSize = 18,
  subtitleLabSize = 14,
  captionLabSize = 14,
  pCutoff = 1e-05,
  pCutoffCol = y,
  FCcutoff = 1,
  cutoffLineType = "longdash",
  cutoffLineCol = "black",
  cutoffLineWidth = 0.4,
  pointSize = 2,
  labSize = 5,
  labCol = "black",
  labFace = "plain",
  boxedLabels = FALSE,
  parseLabels = FALSE,
  shape = 19,
  shapeCustom = NULL,
  col = c("grey30", "forestgreen", "royalblue", "red2"),
  colCustom = NULL,
  colAlpha = 1/2,
  colGradient = NULL,
  colGradientBreaks = c(pCutoff, 1),
  colGradientLabels = c("0", "1.0"),
  colGradientLimits = c(0, 1),
  legendLabels = c("NS", expression(Log[2] ~ FC), "p-value", expression(p - value ~ and ~
    log[2] ~ FC)),
  legendPosition = "top",
  legendLabSize = 14,
  legendIconSize = 5,
  legendDropLevels = TRUE,
  encircle = NULL,
  encircleCol = "black",
  encircleFill = "pink",
  encircleAlpha = 3/4,
  encircleSize = 2.5,
  shade = NULL,
  shadeFill = "grey",
  shadeAlpha = 1/2,
  shadeSize = 0.01,
  shadeBins = 2,
  drawConnectors = FALSE,
  widthConnectors = 0.5,
  typeConnectors = "closed",
  endsConnectors = "first",
  lengthConnectors = unit(0.01, "npc"),
  colConnectors = "grey10",
  max.overlaps = 15,
  maxoverlapsConnectors = NULL,
  min.segment.length = 0,
  directionConnectors = "both",
  arrowheads = TRUE,
  hline = NULL,
  hlineType = "longdash",
  hlineCol = "black",
  hlineWidth = 0.4,
  vline = NULL,
  vlineType = "longdash",
  vlineCol = "black",
  vlineWidth = 0.4,
  gridlines.major = TRUE,
  gridlines.minor = TRUE,
  border = "partial",
  borderWidth = 0.8,
  borderColour = "black",
  raster = FALSE
)
}
\arguments{
\item{toptable}{A data-frame of test statistics (if not, a data frame,
an attempt will be made to convert it to one). Requires at least
the following: column for variable names (can be rownames); a column
for log2 fold changes; a column for nominal or adjusted p-value.}

\item{lab}{A column name in \code{toptable} containing variable names.
Can be \code{rownames(toptable)}.}

\item{x}{A column name in \code{toptable} containing log2 fold changes.}

\item{y}{A column name in \code{toptable} containing nominal or adjusted
p-values.}

\item{selectLab}{A vector containing a subset of lab.}

\item{xlim}{Limits of the x-axis.}

\item{ylim}{Limits of the y-axis.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{axisLabSize}{Size of x- and y-axis labels.}

\item{title}{Plot title.}

\item{subtitle}{Plot subtitle.}

\item{caption}{Plot caption.}

\item{titleLabSize}{Size of plot title.}

\item{subtitleLabSize}{Size of plot subtitle.}

\item{captionLabSize}{Size of plot caption.}

\item{pCutoff}{Cut-off for statistical significance. A horizontal line
will be drawn at -log10(pCutoff).}

\item{pCutoffCol}{Column name of statistical significance values to be used as
the cut-off. A typical usage situation would be to pass nominal [un-adjusted]
p-values as 'y', but adjusted p-values as pCutoffCol. In this way, a
plot is generated via -log10(unadjusted p-value), but cut-offs based on
adjusted p-values.}

\item{FCcutoff}{Cut-off for absolute log2 fold-change. Vertical lines will
be drawn at the negative and positive values of log2FCcutoff.}

\item{cutoffLineType}{Line type for \code{FCcutoff} and \code{pCutoff}
('blank', 'solid', 'dashed', 'dotted', 'dotdash', 'longdash', 'twodash').}

\item{cutoffLineCol}{Line colour for \code{FCcutoff} and \code{pCutoff}.}

\item{cutoffLineWidth}{Line width for \code{FCcutoff} and \code{pCutoff}.}

\item{pointSize}{Size of plotted points for each variable. Can be
a single value or a vector of sizes.}

\item{labSize}{Size of labels for each variable.}

\item{labCol}{Colour of labels for each variable.}

\item{labFace}{Font face of labels for each variable.}

\item{boxedLabels}{Logical, indicating whether or not to draw labels in
boxes.}

\item{parseLabels}{Logical, indicating whether or not to parse expressions
in labels}

\item{shape}{Shape of the plotted points. Either a single value for
all points, or 4 values corresponding to the default 4 legend labels
specified by \code{legendLabels}.}

\item{shapeCustom}{Named vector / key-value pairs that will over-ride the
default shape scheme. The order must match that of \code{toptable}.
Names / keys relate to groups / categories; values relate to shape encodings.}

\item{col}{Colour shading for plotted points, corresponding to
the default 4 legend labels specified by \code{legendLabels}.}

\item{colCustom}{Named vector / key-value pairs that will over-ride the
default colour scheme. The order must match that of \code{toptable}.
Names / keys relate to groups / categories; values relate to colour.}

\item{colAlpha}{Alpha for purposes of controlling colour transparency of
variable points.}

\item{colGradient}{If activated, over-rides the default discrete colour scheme
and replaces it with a continous scheme that shades based on nominal or 
adjusted p-value specified by \code{y}. For example, c('red2', 'blue2').}

\item{colGradientBreaks}{Break-points for the two colours specified by
colGradient.}

\item{colGradientLabels}{Labels for the break-points specified by
colGradientBreaks.}

\item{colGradientLimits}{Limits of the colour scheme specified by
colGradient, i.e., max and min possible p-values.}

\item{legendLabels}{Plot legend text labels.}

\item{legendPosition}{Position of legend ('top', 'bottom', 'left',
'right').}

\item{legendLabSize}{Size of plot legend text.}

\item{legendIconSize}{Size of plot legend icons / symbols.}

\item{legendDropLevels}{Logical, drop unused factor levels from legend.}

\item{encircle}{A vector of variable names to encircle.}

\item{encircleCol}{Colour of the encircled line.}

\item{encircleFill}{Colour fill of the encircled region.}

\item{encircleAlpha}{Alpha for purposes of controlling colour transparency of
encircled region.}

\item{encircleSize}{Line width of the encircled line.}

\item{shade}{A vector of variable names to shade.}

\item{shadeFill}{Colour of shaded regions.}

\item{shadeAlpha}{Alpha for purposes of controlling colour transparency of
shaded region.}

\item{shadeSize}{Size of the shade contour lines.}

\item{shadeBins}{Number of bins for the density of the shade.}

\item{drawConnectors}{Logical, indicating whether or not to connect plot
labels to their corresponding points by line connectors.}

\item{widthConnectors}{Line width of connectors.}

\item{typeConnectors}{Have the arrow head open ('open') or filled ('closed')?}

\item{endsConnectors}{Which end of connectors to draw arrow head? ('last',
'first', 'both').}

\item{lengthConnectors}{Length (size) of the connector arrowheads.}

\item{colConnectors}{Line colour of connectors and line segments.}

\item{max.overlaps}{Equivalent of max.overlaps in ggrepel. Set to
'Inf' to always display all labels when drawConnectors = TRUE.}

\item{maxoverlapsConnectors}{See max.overlaps.}

\item{min.segment.length}{When drawConnectors = TRUE, specifies the minimum
length of the connector line segments.}

\item{directionConnectors}{direction in which to draw connectors.
'both', 'x', or 'y'.}

\item{arrowheads}{Logical, indicating whether or not to draw arrow heads or
or just have straight lines.}

\item{hline}{Draw one or more horizontal lines passing through this/these
values on y-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{hlineType}{Line type for \code{hline} ('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash').}

\item{hlineCol}{Colour of \code{hline}.}

\item{hlineWidth}{Width of \code{hline}.}

\item{vline}{Draw one or more vertical lines passing through this/these
values on x-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{vlineType}{Line type for \code{vline} ('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash').}

\item{vlineCol}{Colour of \code{vline}.}

\item{vlineWidth}{Width of \code{vline}.}

\item{gridlines.major}{Logical, indicating whether or not to draw major
gridlines.}

\item{gridlines.minor}{Logical, indicating whether or not to draw minor
gridlines.}

\item{border}{Add a border for just the x and y axes ('partial') or the
entire plot grid ('full')?}

\item{borderWidth}{Width of the border on the x and y axes.}

\item{borderColour}{Colour of the border on the x and y axes.}

\item{raster}{Logical, indicating whether to rasterize the geom_point layer. 
Requires installation of \code{\link[ggrastr:geom_point_rast]{ggrastr}}.}
}
\value{
A \code{\link{ggplot2}} object.
}
\description{
Volcano plots represent a useful way to visualise the results of
differential expression analyses. Here, we present a highly-configurable
function that produces publication-ready volcano plots [@EnhancedVolcano].
\code{EnhancedVolcano} will attempt to fit as many variable names in
the plot window as possible, thus avoiding 'clogging' up the plot with
labels that could not otherwise have been read.
}
\details{
Volcano plots represent a useful way to visualise the results of differential expression analyses. Here, we present a highly-configurable function that produces publication-ready volcano plots [@EnhancedVolcano]. \code{EnhancedVolcano} will attempt to fit as many variable names in the plot window as possible, thus avoiding 'clogging' up the plot with labels that could not otherwise have been read.
}
\examples{
library('pasilla')
pasCts <- system.file('extdata', 'pasilla_gene_counts.tsv',
  package='pasilla', mustWork=TRUE)
pasAnno <- system.file('extdata', 'pasilla_sample_annotation.csv',
  package='pasilla', mustWork=TRUE)
cts <- as.matrix(read.csv(pasCts,sep='\t',row.names='gene_id'))
coldata <- read.csv(pasAnno, row.names=1)
coldata <- coldata[,c('condition','type')]
rownames(coldata) <- sub('fb', '', rownames(coldata))
cts <- cts[, rownames(coldata)]
library('DESeq2')
dds <- DESeqDataSetFromMatrix(countData = cts,
  colData = coldata,
  design = ~ condition)

featureData <- data.frame(gene=rownames(cts))
mcols(dds) <- DataFrame(mcols(dds), featureData)
dds <- DESeq(dds)
res <- results(dds)

EnhancedVolcano(res,
  lab = rownames(res),
  x = 'log2FoldChange',
  y = 'pvalue',
  pCutoff = 10e-4,
  FCcutoff = 1.333,
  xlim = c(-5.5, 5.5),
  ylim = c(0, -log10(10e-12)),
  pointSize = 1.5,
  labSize = 2.5,
  title = 'DESeq2 results',
  subtitle = 'Differential expression',
  caption = 'FC cutoff, 1.333; p-value cutoff, 10e-4',
  legendPosition = "right",
  legendLabSize = 14,
  col = c('grey30', 'forestgreen', 'royalblue', 'red2'),
  colAlpha = 0.9,
  drawConnectors = TRUE,
  hline = c(10e-8),
  widthConnectors = 0.5)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
