% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricMCB_cv.R
\name{metricMCB.cv}
\alias{metricMCB.cv}
\title{Calculation of model AUC for Methylation Correlation Blocks using cross validation}
\usage{
metricMCB.cv(MCBset,data_set,Surv,nfold,
Method,predict_time,alpha,n_mstop,n_nu,theta,silent)
}
\arguments{
\item{MCBset}{Methylation Correlation Block information returned by the IndentifyMCB function.}

\item{data_set}{methylation matrix used for training the model in the analysis.}

\item{Surv}{Survival function contain the survival information for training.}

\item{nfold}{fold used in the cross validation precedure.}

\item{Method}{model used to calculate the compound values for multiple Methylation correlation blocks. Options include "svm", "cox", "mboost", and "enet". The default option is SVM method.}

\item{predict_time}{time point of the ROC curve used in the AUC calculations, default is 3 years.}

\item{alpha}{The elasticnet mixing parameter, with 0 <= alpha <= 1. alpha=1 is the lasso penalty, and alpha=0 the ridge penalty. It works only when "enet" Method is selected.}

\item{n_mstop}{an integer giving the number of initial boosting iterations. If mstop = 0, the offset model is returned. It works only when "mboost" Method is selected.}

\item{n_nu}{a double (between 0 and 1) defining the step size or shrinkage parameter in mboost model. It works only when "mboost" Method is selected.}

\item{theta}{penalty used in the penalized coxph model, which is theta/2 time sum of squared coefficients. default is 1. It works only when "cox" Method is selected.}

\item{silent}{Ture indicates that processing information and progress bar will be shown.}
}
\value{
Object of class \code{list} with elements (XXX will be replaced with the model name you choose):
 \tabular{ll}{
   \code{MCB_matrix} \tab Prediction results of model. \cr
   \code{auc_results} \tab AUC results for each model. \cr
 }
}
\description{
To enable quantitative analysis of the methylation patterns
within individual Methylation Correlation Blocks across many samples, a single metric to
define the methylated pattern of multiple CpG sites within each block.
Compound scores which calculated all CpGs within individual Methylation Correlation Blocks by SVM model
were used as the compound methylation values of Methylation Correlation Blocks.
}
\examples{
#import datasets
data(demo_survival_data)
datamatrix<-create_demo()
data(demo_MCBinformation)
#select MCB with at least 3 CpGs.
demo_MCBinformation<-demo_MCBinformation[demo_MCBinformation[,"CpGs_num"]>2,]

trainingset<-colnames(datamatrix) \%in\% sample(colnames(datamatrix),0.6*length(colnames(datamatrix)))
testingset<-!trainingset
#create the results using Cox regression. 
mcb_cox_res<-metricMCB.cv(MCBset = demo_MCBinformation,
               data_set = datamatrix,
               Surv = demo_survival_data,
               Method = "cox")

}
\references{
Xin Yu et al. 2019 Predicting disease progression in lung adenocarcinoma patients based on methylation correlated blocks using ensemble machine learning classifiers (under review)
}
\author{
Xin Yu
}
\keyword{Correlation}
\keyword{Methylation}
