# prepare function run results for testing
data(mtrx_samtools_reticulate)
N_cores = 1L
th<-50
sam <- 6L
filtered_mtrx <- filt_samples(mtrx_samtools_reticulate[4500:5500,c(seq_len(5),83)],th=th,smry_fun=max)
filtered_mtrx[403:601,sam] <- as.integer(filtered_mtrx[403:601,sam]/10)

result <- run_ELViS(
    filtered_mtrx,N_cores=N_cores,verbose = FALSE,reduced_output=TRUE)
result_core <- run_ELViS_core(
    filtered_mtrx,N_cores=N_cores,verbose = FALSE,reduced_output=TRUE)

normalized_mtrx <- get_normalized_data(filtered_mtrx)

win <- get_window_v1(normalized_mtrx$Y,sam=sam)

refupate_data <- update_reference_segments(normalized_mtrx,cores=N_cores)
refupate_data_seg_cls <- get_segments_and_clusters(refupate_data,cores=N_cores)

rescued_data <- segupdated_data_p2 <-
    list(
        sample_Ids = refupate_data$sample_Ids,
        Y =          refupate_data$Y_recentered,
        Z =          refupate_data$Z_recentered,
        segment.K =  refupate_data_seg_cls$segment.K,
        clust.list = refupate_data_seg_cls$clust.list
    )

new_Y_p2 <- detect_bp__update_ref(rescued_data = rescued_data,X=filtered_mtrx,cores=N_cores)

i <- sam
list_base <- rep(list(integer(0)),NCOL(filtered_mtrx))
BPs2.level1.plus <-  list_base
BPs2.level1.plus[[i]] <- c(402L,601L)
BPs2.level2 <- list_base
BPs2.level2[[i]] <- c(402L,601L)
new_Y_p2_single <- detect_bp__update_ref__sub_updateY(i,X_input=filtered_mtrx,Y=rescued_data$Y,Z=rescued_data$Z
                                   ,BPs2.level1.plus=BPs2.level1.plus,BPs2.level2=BPs2.level2)


nseg <- 2L
segment.table <- data.frame(seg = seq_len(3),begin = c(1,403,602),end = c(402,601,1001))
segbps <- get_segbps(nseg,nseg+1,segment.table)

len.outwinreg <- vapply(segbps, FUN = length, FUN.VALUE = integer(1))
dt_zscores <- get_dt_zscores(nseg,segbps,rescued_data$Y,sam)

baseseg <- get_baseseg(dt_zscores,len.outwinreg)

segtable_p2 <- segmentation_2nd_phase(X=filtered_mtrx,Y=new_Y_p2,cores=N_cores,verbose=FALSE)




# true values
{
    true_mtrx <-
        matrix(c(
            98,99,99,98,99,100,103,106,107,109
            ),ncol=2)
    true_dimnames = list(NULL, c("Control_100X_58.bam","Control_100X_61.bam"))
    true_mtrx_dimnames <-
        structure(
            true_mtrx
            ,dimnames = true_dimnames
        )

    true_new_Y <-
        matrix(c(
            1.08888888888889,1.1,1.1,1.08888888888889,1.1,1.14122681883024,1.17546362339515,1.20970042796006,1.22111269614836,1.24393723252496
        ),ncol=2)

    true_new_Y_single <- c(
        0.597938144329897,0.628865979381443,0.639175257731959,0.649484536082474,0.649484536082474
    )

    true_segtable_p2 <-
        data.frame(
            id = c(6,6,6)
            ,sampleID = c("Deletion_100X_200bp_CN-0.5_3079.bam","Deletion_100X_200bp_CN-0.5_3079.bam","Deletion_100X_200bp_CN-0.5_3079.bam")
            ,seg = c(1,2,3)
            ,begin = c(1,403,602)
            ,end = c(402,601,1001)
            ,mu.x = c(97.8940149625935163157919305376708507537841796875,4.42211055276381870271507068537175655364990234375,97.8940149625935163157919305376708507537841796875)
            ,sd.x = c(13.8894328055612223948855898925103247165679931640625,0.57094071570319171460283769192756153643131256103515625,13.8894328055612223948855898925103247165679931640625)
            ,mu.y = c(1.0414256910914205800366971743642352521419525146484375,0.04704372928472148884804227009226451627910137176513671875,1.0414256910914205800366971743642352521419525146484375)
            ,sd.y = c(0.1477599234634172919999883788477745838463306427001953125,0.006073837401097788128712107180717794108204543590545654296875,0.1477599234634172919999883788477745838463306427001953125)
            ,mu.z = c(-0.126634275733686518794485209582489915192127227783203125,-9.6449331882393689596710828482173383235931396484375,-0.126634275733686518794485209582489915192127227783203125)
            ,sd.z = c(2.140655329523518002332593823666684329509735107421875,17.0579527634046002049217349849641323089599609375,2.140655329523518002332593823666684329509735107421875)
            ,cohort.y = c(1.0600318628056459857589288731105625629425048828125,0.91658665490695689914701915768091566860675811767578125,1.0600318628056459857589288731105625629425048828125)
            ,baseline = c(1,0,1)
            ,state = c(1,2,1)
            ,cn = c(1,0.05224188571854883333944741252707899548113346099853515625,1)
        )


    true_result_final_output <-
        data.table(
            id = c(1,2,3,4,5,6,6,6)
            ,sampleID = c("Control_100X_58.bam","Control_100X_61.bam","Control_100X_64.bam","Control_100X_83.bam","Control_100X_87.bam","Deletion_100X_200bp_CN-0.5_3079.bam","Deletion_100X_200bp_CN-0.5_3079.bam","Deletion_100X_200bp_CN-0.5_3079.bam")
            ,seg = c(1,1,1,1,1,1,2,3)
            ,begin = c(1,1,1,1,1,1,403,602)
            ,end = c(1001,1001,1001,1001,1001,402,601,1001)
            ,mu.x = c(90.8021978021977957951094140298664569854736328125,96.11388611388611025176942348480224609375,92.092907092907097421630169264972209930419921875,99.7452547452547406692247022874653339385986328125,93.8041958041957997238569078035652637481689453125,97.8940149625935163157919305376708507537841796875,4.42211055276381870271507068537175655364990234375,97.8940149625935163157919305376708507537841796875)
            ,sd.x = c(7.90574697070651044583655675523914396762847900390625,14.053932438396628867849358357489109039306640625,13.5564139668409229244616653886623680591583251953125,10.011994804235566647321320488117635250091552734375,12.3298670867784441185222021886147558689117431640625,13.8894328055612223948855898925103247165679931640625,0.57094071570319171460283769192756153643131256103515625,13.8894328055612223948855898925103247165679931640625)
            ,mu.y = c(1.022547272547272623199887675582431256771087646484375,1.058311058311058427960915651055984199047088623046875,1.1272081651518615075246998458169400691986083984375,1.007527825709643831686435078154318034648895263671875,1.0086472667117829526972627718350850045680999755859375,1.0414256910914205800366971743642352521419525146484375,0.04704372928472148884804227009226451627910137176513671875,1.0414256910914205800366971743642352521419525146484375)
            ,sd.y = c(0.0890286821025507990601255414730985648930072784423828125,0.1547480048271901165168884517697733826935291290283203125,0.1659291795206967179421297942099045030772686004638671875,0.10113126064884407628863272066155332140624523162841796875,0.132579215986865006637884789597592316567897796630859375,0.1477599234634172919999883788477745838463306427001953125,0.006073837401097788128712107180717794108204543590545654296875,0.1477599234634172919999883788477745838463306427001953125)
            ,mu.z = c(0.0017065801670043414216271226990784271038137376308441162109375,0.34000165655533198805215988613781519234180450439453125,0.89083951936635319412971512065269052982330322265625,-0.274628243298388918791630430860095657408237457275390625,-0.1571780143028280452011102852338808588683605194091796875,-0.07197153544395464008776031050729216076433658599853515625,-9.0874862077569815710376133210957050323486328125,-0.07197153544395464008776031050729216076433658599853515625)
            ,sd.z = c(1.6546084602640436234111120938905514776706695556640625,1.8141718117148197819687993614934384822845458984375,1.15079096244919387714844560832716524600982666015625,0.69875684089358813810832771196146495640277862548828125,0.6543323584648856883205780832213349640369415283203125,2.00435779581051320974438567645847797393798828125,8.9764787212677195071819369331933557987213134765625,2.00435779581051320974438567645847797393798828125)
            ,cohort.y = c(1.02604686075016982016450128867290914058685302734375,1.02604686075016982016450128867290914058685302734375,1.02604686075016982016450128867290914058685302734375,1.02604686075016982016450128867290914058685302734375,1.02604686075016982016450128867290914058685302734375,1.05407307046960685426029158406890928745269775390625,0.91309701052409641963691910859779454767704010009765625,1.05407307046960685426029158406890928745269775390625)
            ,baseline = c(1,1,1,1,1,1,0,1)
            ,state = c(1,1,1,1,1,1,2,1)
            ,cn = c(1,1,1,1,1,1,0.05214675067099673599901876741569139994680881500244140625,1)
        )

    true_result_Y <-
        structure(
            matrix(
                ncol=2,c(1.103603603603603655614051604061387479305267333984375,1.1148648648648649128745091729797422885894775390625,1.1148648648648649128745091729797422885894775390625,1.103603603603603655614051604061387479305267333984375,1.1148648648648649128745091729797422885894775390625,1.101101101101101154000616588746197521686553955078125,1.1341341341341342197068797759129665791988372802734375,1.16716716716716728541314296307973563671112060546875,1.1781781781781781592854940754477865993976593017578125,1.2002002002002003511194061502465046942234039306640625)),
            dimnames=list(NULL,c("Control_100X_58.bam","Control_100X_61.bam")))


    true_get_BPsegment_v2 <-
        data.frame(
            seg = c(1,2,3)
            ,begin = c(1,403,602)
            ,end = c(402,601,1001)
            ,mu.x = c(97.8940149625935163157919305376708507537841796875,4.42211055276381870271507068537175655364990234375,97.8940149625935163157919305376708507537841796875)
            ,sd.x = c(13.8894328055612223948855898925103247165679931640625,0.57094071570319171460283769192756153643131256103515625,13.8894328055612223948855898925103247165679931640625)
            ,mu.y = c(1.0414256910914205800366971743642352521419525146484375,0.04704372928472148884804227009226451627910137176513671875,1.0414256910914205800366971743642352521419525146484375)
            ,sd.y = c(0.1477599234634172919999883788477745838463306427001953125,0.006073837401097788128712107180717794108204543590545654296875,0.1477599234634172919999883788477745838463306427001953125)
            ,mu.z = c(-0.126634275733686518794485209582489915192127227783203125,-9.6449331882393689596710828482173383235931396484375,-0.126634275733686518794485209582489915192127227783203125)
            ,sd.z = c(2.140655329523518002332593823666684329509735107421875,17.0579527634046002049217349849641323089599609375,2.140655329523518002332593823666684329509735107421875)
            ,cohort.y = c(1.0600318628056459857589288731105625629425048828125,0.91658665490695689914701915768091566860675811767578125,1.0600318628056459857589288731105625629425048828125)
            ,baseline = c(1,0,1)
            ,state = c(1,2,1)
        )


    true_g <- make_empty_graph(n = 4,directed = FALSE)
    V(true_g)$name <- paste0("v",seq_len(4))
    true_g <- add_edges(true_g, paste0("v",combn(seq_len(4),2)[,c(1,3,5,6)] |> as.vector()))  # Connect node 1 to 2 and node 3 to 4
    E(true_g)$weight <- c(0.90909090909090906063028114658663980662822723388671875,0.200000000000000011102230246251565404236316680908203125,0.66666666666666662965923251249478198587894439697265625,0.125,0.76923076923076916244781386922113597393035888671875,0.83333333333333337034076748750521801412105560302734375)[c(1,3,5,6)]
}


test_that("Main Functions",{
    # filt_samples
    expect_equal(
        filtered_mtrx[1:5,1:2]
        ,true_mtrx_dimnames
    )

    # get_normalized_data
    expect_equal(normalized_mtrx$sample_Ids[1:2],c("Control_100X_58.bam","Control_100X_61.bam"))
    expect_equal(normalized_mtrx$Y[1:5,1:2],
                 structure(matrix(c(
                     1.10112359550562,1.1123595505618,1.1123595505618,1.10112359550562,1.1123595505618,1.04166666666667,1.07291666666667,1.10416666666667,1.11458333333333,1.13541666666667
                     ),ncol=2)
                           ,dimnames = true_dimnames))
    expect_equal(normalized_mtrx$Z[1:5,1:2],
                 matrix(
                     ncol=2,c(0.59162107817000986198507916924427263438701629638671875,0.496723722390196409381957209916436113417148590087890625,0.50424974124083055126988028860068880021572113037109375,-0.02665688914404186482531855517663643695414066314697265625,0.0666338315510821288523146677107433788478374481201171875,-0.360760899333272322397903053570189513266086578369140625,-0.154927678635170595899950285456725396215915679931640625,0.264970944282028220140290386552806012332439422607421875,0.50840808497319056602492537422222085297107696533203125,0.70246634605487556779479518809239380061626434326171875))
                     )

    # get_window_v1
    expect_equal(
        win
        ,matrix(c(
            1,783,797,976,783,796,957,1001
            ),ncol=2)
    )

    # get_outmat_v1
    expect_equal(
        get_outmat_v1(normalized_mtrx$Y,win)[1:4,1:2]
        ,matrix(
            ncol=2,c(1.41177995972559688908631869708187878131866455078125,-0.50832196685171737726705032400786876678466796875,-1.092460147956228144749957209569402039051055908203125,-0.197789342050690153396175219313590787351131439208984375,0.0191050440929933264266882275705938809551298618316650390625,0.07873132308881337915185127940276288427412509918212890625,-0.8490623721418781855163615546189248561859130859375,1.4697245784998698159284913344890810549259185791015625))
    )

    # search_Kopt
    {
        set.seed(32624364);expect_equal(
            search_Kopt(data.frame(y=normalized_mtrx$Y[,1],z=normalized_mtrx$Z[,1]))
            ,2
        )
    }


    # get_clust_seg - output object is too complex for unit testing


    # update_reference_segments
    expect_equal(refupate_data$sample_Ids[1:2],c("Control_100X_58.bam","Control_100X_61.bam"))
    expect_equal(refupate_data$Y[1:5,1:2],
                 matrix(
                     ncol=2,c(1.103603603603603655614051604061387479305267333984375,1.1148648648648649128745091729797422885894775390625,1.1148648648648649128745091729797422885894775390625,1.103603603603603655614051604061387479305267333984375,1.1148648648648649128745091729797422885894775390625,1.1412268188302425730995537378476001322269439697265625,1.175463623395149870276554793235845863819122314453125,1.2097004279600571674535558486240915954113006591796875,1.2211126961483593778012846087221987545490264892578125,1.24393723252496446463055690401233732700347900390625))
    )
    expect_equal(refupate_data$Z[1:5,1:2],
                 matrix(
                     ncol=2,c(-0.14014214786934975354171228900668211281299591064453125,0.0293676149262151776897500354834846802987158298492431640625,0.106707054442156834550559096896904520690441131591796875,-0.01619841459619213164256024128917488269507884979248046875,0.0267898687859309224401638260815161629579961299896240234375,0.491389708591333740361761783788097091019153594970703125,0.5144167000753896434872558529605157673358917236328125,0.80840226427225270189325101455324329435825347900390625,0.82275299862957051999501345562748610973358154296875,0.969237330286549791935613029636442661285400390625))
    )
    expect_equal(
        refupate_data$segment.K_initial
        ,c(2,2,2,1,1,1)
    )

    # get_segments_and_clusters
    expect_equal(refupate_data_seg_cls$sample_Ids[1:2],c("Control_100X_58.bam","Control_100X_61.bam"))
    expect_equal(
        refupate_data_seg_cls$segment.K
        ,c(2,2,2,1,1,1)
    )

    # detect_bp__update_ref
    expect_equal(new_Y_p2[1:5,1:2],
                 structure(
                     matrix(
                         ncol=2,c(1.103603603603603655614051604061387479305267333984375,1.1148648648648649128745091729797422885894775390625,1.1148648648648649128745091729797422885894775390625,1.103603603603603655614051604061387479305267333984375,1.1148648648648649128745091729797422885894775390625,1.1412268188302425730995537378476001322269439697265625,1.175463623395149870276554793235845863819122314453125,1.2097004279600571674535558486240915954113006591796875,1.2211126961483593778012846087221987545490264892578125,1.24393723252496446463055690401233732700347900390625)),
                     dimnames=list(NULL,NULL))
    )

    # detect_bp__update_ref__sub_updateY
    expect_equal(new_Y_p2_single[1:5],
                 c(1.08510638297872,1.07446808510638,1.06382978723404,1.08510638297872,1.07446808510638)
    )

    # get_segbps
    expect_equal(segbps[[2]][seq_len(5)], 403:407)

    # get_dt_zscores
    expect_equal(dt_zscores,
                 data.frame(Q1.zscore=c(0.697561051279304,1000),
                            max.zscore=c(167.715007187227,1000))
                 )


    # segmentation_2nd_phase
    expect_equal(
        segtable_p2$segtable.list[[sam]]
        ,true_segtable_p2
    )

    # get_baseseg
    expect_equal(baseseg,1)

    # run_ELViS
    expect_equal(result$final_output,true_result_final_output)
    expect_true(result$is_reduced_output)
    expect_equal(result$final_call,list(segmented_samples = 6, cnv_samples = 6))
    expect_equal(result$new_Y_p2[1:5,1:2],true_result_Y)

    # run_ELViS_core
    expect_equal(result_core$final_output,true_result_final_output)
    expect_true(result_core$is_reduced_output)
    expect_equal(result_core$final_call,list(segmented_samples = 6, cnv_samples = 6))
    expect_equal(result_core$new_Y_p2[1:5,1:2],true_result_Y)

    # get_new_baseline
    expect_equal(get_new_baseline(result),c(1,1,1,1,1,1))

    # detect_BPs
    expect_equal(
        detect_BPs(y=diff(new_Y_p2[,sam]), q.Y=10, half.width=250, prob.cutoff = 0.95)
        ,c("95%"=402,"95%"=601)
    )

    # get_BPsegment_v2
    expect_equal(
        get_BPsegment_v2(X=filtered_mtrx, Y=new_Y_p2, sampleID=colnames(filtered_mtrx)[sam])
        ,true_get_BPsegment_v2
    )

    # gen_dist_graph
    expect_equal(
        igraph::as_adjacency_matrix(
            gen_dist_graph(seq_len(4),combn(seq_len(4),2),c(0.1,4,0.5,7,0.3,0.2),1)
            , attr = "weight", sparse = FALSE)
        ,
        igraph::as_adjacency_matrix(
            true_g
            , attr = "weight", sparse = FALSE)
    )

    # get_subcl
    expect_equal(
        get_subcl(true_g)
        ,list(c("v1","v2","v4"),"v3")
    )

    # clique_weight
    expect_equal(
        clique_weight(cliques(true_g)[[8]],true_g)
        ,2.34498834
    )

    # get_window_core
    expect_equal(
        get_window_core(new_Y_p2[,sam])
        ,matrix(c(
            1,16,46,66,81,131,271,312,637,721,742,755,769,15,40,65,80,131,251,296,635,720,742,754,768,997
            ),ncol=2)
    )

    # compute_CN
    expect_equal(
        compute_CN(true_get_BPsegment_v2)
        ,c(1,0.05224188571854883333944741252707899548113346099853515625,1)
    )

    # smooth_segment
    expect_equal(
        smooth_segment(true_get_BPsegment_v2)
        ,data.frame(
            seg = c(1,2,3)
            ,begin = c(1,403,602)
            ,end = c(402,601,1001)
            ,mu.x = c(97.8940149625935163157919305376708507537841796875,4.42211055276381870271507068537175655364990234375,97.8940149625935163157919305376708507537841796875)
            ,sd.x = c(13.8894328055612223948855898925103247165679931640625,0.57094071570319171460283769192756153643131256103515625,13.8894328055612223948855898925103247165679931640625)
            ,mu.y = c(1.0414256910914205800366971743642352521419525146484375,0.04704372928472148884804227009226451627910137176513671875,1.0414256910914205800366971743642352521419525146484375)
            ,sd.y = c(0.1477599234634172919999883788477745838463306427001953125,0.006073837401097788128712107180717794108204543590545654296875,0.1477599234634172919999883788477745838463306427001953125)
            ,mu.z = c(-0.126634275733686518794485209582489915192127227783203125,-9.6449331882393689596710828482173383235931396484375,-0.126634275733686518794485209582489915192127227783203125)
            ,sd.z = c(2.140655329523518002332593823666684329509735107421875,17.0579527634046002049217349849641323089599609375,2.140655329523518002332593823666684329509735107421875)
            ,cohort.y = c(1.0600318628056459857589288731105625629425048828125,0.91658665490695689914701915768091566860675811767578125,1.0600318628056459857589288731105625629425048828125)
            ,baseline = c(1,0,1)
            ,state = c(1,2,1)
        )
    )

})



test_that("Helper Functions in Main.R", {

    # capture_params_glue
    expect_equal(
        capture_params_glue(a=1,b=2,c=3)
        ,glue("a = 1 b = 2 c = 3")
    )
    # norm_fun
    expect_equal(
        norm_fun(seq_len(5))
        ,c(0.25, 0.50, 0.75, 1.00, 1.25)
    )

    # anno_color_var
    expect_equal(
        anno_color_var(seq_len(10))
        ,list(
            var = seq_len(10)
            ,var_col = colorRamp2(  quantile(   seq_len(10),
                                                probs=seq(0,1,length=length(c("#A50026","#FFFFBF","#313695")))),
                                    c("#A50026","#FFFFBF","#313695"))
        )
    )

    # pooled_sd
    expect_equal(
        pooled_sd(1,2,40,50)
        ,1.63415255
    )


    # t_col
    expect_equal(
        t_col("red")
        ,"#FF00007F"
    )




})


