% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_coexp_network.R
\name{build_coexp_network}
\alias{build_coexp_network}
\title{Builds a coexpression network from an expressionSet}
\usage{
build_coexp_network(exprs, gene.list, method = "spearman", flag = "rank")
}
\arguments{
\item{exprs}{matrix of expression data}

\item{gene.list}{array of gene labels}

\item{method}{correlation method to use, default Spearman's rho}

\item{flag}{string to indicate if the network should be ranked}
}
\value{
net Matrix symmetric
}
\description{
The function generates a dense coexpression network from expression data stored as a 
matrix, with the genes as row labels, and samples as column labels. 
Correlation coefficicents are used as to weight the edges of the nodes (genes). 
Calls \code{\link{cor}}.
}
\examples{
exprs <- matrix( rnorm(1000), ncol=10,byrow=TRUE)
gene.list <- paste('gene',1:100, sep='')
sample.list <- paste('sample',1:10, sep='')
rownames(exprs) <- gene.list
colnames(exprs) <- sample.list
network <- build_coexp_network(exprs, gene.list)

}
\keyword{ExpressionSet}
\keyword{coexpression}
\keyword{dense}
\keyword{expressionSet}
\keyword{network}
