% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_set.R, R/tidy_phyloseq_tse.R
\name{tidy_phyloseq_tse}
\alias{tidy_phyloseq_tse}
\title{Tidy a Phyloseq or TreeSummarizedExperiment Object}
\usage{
tidy_phyloseq_tse(obj)

tidy_phyloseq_tse(obj)
}
\arguments{
\item{obj}{A \code{phyloseq::phyloseq} or \code{TreeSummarizedExperiment::TreeSummarizedExperiment} object.}
}
\value{
A cleaned and tidied object of the same class.

A cleaned and filtered object of the same class with updated taxonomy.
}
\description{
Cleans and standardizes a microbiome dataset, supporting both
\code{phyloseq} and \code{TreeSummarizedExperiment}. Performs:
\itemize{
\item Standardization of taxonomic ranks (if available)
\item Removal of leading/trailing whitespace in taxa names
\item Filtering out zero-count taxa
\item Exclusion of "Chloroplast" and "Mitochondria" classifications (if applicable)
}

Cleans and standardizes a microbiome object by:
\itemize{
\item Removing taxonomic prefixes (e.g. \code{k__}, \code{p__})
\item Trimming whitespace
\item Renaming \code{Domain} to \code{Kingdom} (if present)
\item Removing taxa with "Chloroplast" or "Mitochondria" in \strong{any} rank
\item Filtering out taxa with zero total abundance
\item Ensuring robust handling of both phyloseq and TreeSummarizedExperiment formats
}
}
\details{
Tidy a Phyloseq Object and Remove Zero/Negative Count Samples

This function standardizes taxonomic ranks, removes unnecessary whitespace,
and filters unwanted classifications, ensuring consistency for downstream analysis.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")
  tidy_physeq <- tidy_phyloseq_tse(physeq_16SOTU)
}

if (requireNamespace("DspikeIn", quietly = TRUE)) {
  # Load example phyloseq object
  data("physeq_16SOTU", package = "DspikeIn")

  # ----------- Tidy phyloseq object -----------
  tidy_physeq <- tidy_phyloseq_tse(physeq_16SOTU)

  # ----------- Tidy TSE object -----------
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  tidy_tse <- tidy_phyloseq_tse(tse_16SOTU)
}

}
