% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_set.R
\name{set_nf}
\alias{set_nf}
\title{Set Normalization Factors in the Sample Data of the Phyloseq Object}
\usage{
set_nf(obj, scaling.factor)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing microbial data.}

\item{scaling.factor}{A vector of normalization factors.}
}
\value{
A phyloseq object with updated sample data.
}
\description{
Set Normalization Factors in the Sample Data of the Phyloseq Object
}
\examples{
if (requireNamespace("phyloseq", quietly = TRUE)) {
  data("physeq_ITSOTU", package = "DspikeIn")

  # Create normalization factors (e.g., all ones)
  nf <- rep(1, phyloseq::nsamples(physeq_ITSOTU))

  # Apply normalization factors
  physeq_ITSOTU <- DspikeIn::set_nf(physeq_ITSOTU, scaling.factor = nf)

  # Check the updated sample data
  head(phyloseq::sample_data(physeq_ITSOTU)$norm_factors)
}
}
