% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_subsample_WithReductionFactor.R
\name{random_subsample_WithReductionFactor}
\alias{random_subsample_WithReductionFactor}
\title{Random Subsampling with Reduction Factor}
\usage{
random_subsample_WithReductionFactor(
  obj,
  reduction_factor = 3,
  output_file = NULL
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{reduction_factor}{A numeric value \eqn{\ge 1} to reduce counts. Default is 3.}

\item{output_file}{Optional. A character string specifying the \code{.rds} file path
to save the result. If \code{NULL}, no file will be saved. Default is \code{NULL}.}
}
\value{
A subsampled object of the same class as the input (\code{phyloseq} or \code{TreeSummarizedExperiment}).
}
\description{
Performs random subsampling on the OTU table of a \code{phyloseq} or
\code{TreeSummarizedExperiment} (TSE) object by dividing each ASV count
by a specified reduction factor and rounding down to the nearest whole number.
Optionally, the result can be saved to disk as an \code{.rds} file.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE) &&
  requireNamespace("phyloseq", quietly = TRUE) &&
  requireNamespace("TreeSummarizedExperiment", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")
  red <- random_subsample_WithReductionFactor(physeq_16SOTU, reduction_factor = 10)
  summary_stats <- summ_phyloseq_sampleID(red)
  print(summary_stats)

  tse <- convert_phyloseq_to_tse(physeq_16SOTU)
  red_tse <- random_subsample_WithReductionFactor(tse, reduction_factor = 10)
  summary_stats <- summ_phyloseq_sampleID(red_tse)
  print(summary_stats)
}

}
