% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportion_adj.R
\name{proportion_adj}
\alias{proportion_adj}
\title{Proportionally Adjust Abundance}
\usage{
proportion_adj(obj, output_file = "proportion_adjusted.rds")
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing microbiome data.}

\item{output_file}{A character string specifying the output file name for the adjusted object.
If \code{NULL}, the object is not saved. Default is "proportion_adjusted.rds".}
}
\value{
A modified object of the same class (\code{phyloseq} or \code{TreeSummarizedExperiment}) with proportionally adjusted and rounded abundance data.
}
\description{
This function normalizes the abundance data in a \code{phyloseq} or \code{TreeSummarizedExperiment}
object by adjusting each sample's counts based on a total value, typically the maximum total
sequence count across all samples. The adjusted counts are then rounded to the nearest integer.
}
\details{
This function extracts the OTU table (or assay in \code{TSE}), normalizes it based on the sample sums,
and updates the original object while maintaining its structure.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  # Load phyloseq object
  data("physeq_16SOTU", package = "DspikeIn")

  normalized_physeq <- proportion_adj(
    physeq_16SOTU,
    output_file = file.path(tempdir(), "proportion_adjusted_physeq.rds")
  )
  print(normalized_physeq)

  # Convert to TSE and apply
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  normalized_tse <- proportion_adj(
    tse_16SOTU,
    output_file = file.path(tempdir(), "proportion_adjusted_tse.rds")
  )
  print(normalized_tse)
}
}
