% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataInput.R
\name{discoDesignSummary}
\alias{discoDesignSummary}
\title{Summarize the experimental design}
\usage{
discoDesignSummary(Metadata)
}
\arguments{
\item{Metadata}{data.frame of sample data, usually generated by
using \code{discoParseMeta} on the column names of the Maindata data.frame. 
If \code{is.null(Metadata)} and Maindata is provided as input, Metadata will 
be generated from Maindata.}
}
\value{
A table where the first row summarizes the number of datapoints for
each timepoint and other cells indicate the number of technical replicates
for a given biological sample.
}
\description{
Using sample times and biological sample Ids, constructs a summary
table of the number of total samples at each timepoint and additionally
summarizes the number of replicates for each biological sample.
}
\examples{
# import example data
Metadata <- SummarizedExperiment::colData(discoGetSimu(TRUE))
# Summarize the experiment design
discoDesignSummary(Metadata)

}
\seealso{
discoParseMeta
}
