% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffSeqLogoSupport.R
\name{enrichDiffLogoTableWithPvalues}
\alias{enrichDiffLogoTableWithPvalues}
\title{Enriches a matrix of difflogo objects with p-values}
\usage{
enrichDiffLogoTableWithPvalues(diffLogoObjMatrix, sampleSizes,
  stackHeight = shannonDivergence, numberOfPermutations = 100)
}
\arguments{
\item{diffLogoObjMatrix}{matrix of difflogo objects}

\item{sampleSizes}{number of sequences behind the pwms behind the given difflogo objects}

\item{stackHeight}{function for the calculation of a divergence measure for two probability vectors}

\item{numberOfPermutations}{the number of permutations to perform for the calculation of stackHeights}
}
\value{
matrix of difflogo objects enriched with p-values
}
\description{
Enriches a matrix of difflogo objects with p-values which quantifies the probability that two PWM-positions are from the same distribution
}
\examples{
motif_folder= "extdata/pwm"
motif_names = c("HepG2","MCF7","HUVEC","ProgFib")
motifs = list()
for (name in motif_names) {
  fileName = paste(motif_folder,"/",name,".pwm",sep="")
  file = system.file(fileName, package = "DiffLogo")
  motifs[[name]] = getPwmFromPwmFile(file)
}
sampleSizes <- c(100, 150, 200, 250)
names(sampleSizes) <- motif_names

diffLogoTableObj = prepareDiffLogoTable(motifs);
diffLogoTableObj$diffLogoObjMatrix = enrichDiffLogoTableWithPvalues(diffLogoTableObj$diffLogoObjMatrix, sampleSizes)
}
\author{
Martin Nettling
}
