% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffSeqLogoSupport.R
\name{enrichDiffLogoObjectWithPvalues}
\alias{enrichDiffLogoObjectWithPvalues}
\title{Enriches a difflogo object with p-values}
\usage{
enrichDiffLogoObjectWithPvalues(diffLogoObj, n1, n2,
  stackHeight = shannonDivergence, numberOfPermutations = 100)
}
\arguments{
\item{diffLogoObj}{matrix of difflogo objects}

\item{n1}{the number of sequences behind the first pwm behind the given difflogo object}

\item{n2}{the number of sequences behind the second pwm behind the given difflogo object}

\item{stackHeight}{function for the calculation of a divergence measure for two probability vectors}

\item{numberOfPermutations}{the number of permutations to perform for the calculation of stackHeights}
}
\value{
enriched difflogo object
}
\description{
Enriches a difflogo object with p-values which quantifies the probability that two PWM-positions are from the same distribution
}
\examples{
motif_folder= "extdata/pwm"
motif_names = c("HepG2","MCF7","HUVEC","ProgFib")
motifs = list()
for (name in motif_names) {
  fileName = paste(motif_folder,"/",name,".pwm",sep="")
  file = system.file(fileName, package = "DiffLogo")
  motifs[[name]] = getPwmFromPwmFile(file)
}

pwm1 = motifs[[motif_names[[1]]]]
pwm2 = motifs[[motif_names[[2]]]]
n1 <- 100
n2 <- 100
diffLogoObj = createDiffLogoObject(pwm1 = pwm1, pwm2 = pwm2)
diffLogoObj = enrichDiffLogoObjectWithPvalues(diffLogoObj, n1, n2)
}
