% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depInfeR.R
\docType{package}
\name{DepInfeR-package}
\alias{DepInfeR-package}
\title{DepInfeR for inferring sample-specific protein dependencies}
\description{
DepInfeR integrates two experimentally accessible input data matrices: 
the drug sensitivity profiles of cancer cell lines or primary tumors 
ex-vivo (X), and the drug affinities of a set of proteins (Y), to infer 
a matrix of molecular protein dependencies of the cancers (ß). 
DepInfeR deconvolutes the protein inhibition effect on the viability 
phenotype by using regularized multivariate linear regression. 
It assigns a “dependence coefficient” to each protein and each sample, 
and therefore could be used to gain a causal and accurate understanding of 
functional consequences of genomic aberrations in a heterogeneous disease, 
as well as to guide the choice of pharmacological intervention for a specific 
cancer type, sub-type, or an individual patient. For more information, 
please read out preprint on bioRxiv: \url{https://doi.org/10.1101/2022.01.11.475864}.
}
\details{
The main functions are:

\itemize{
\item \code{\link{runLASSORegression}} - perform inference of target importance
\item \code{\link{processTarget}} - pre-process drug-protein affinity dataset
}

For detailed information on usage, see the package vignette, by typing
\code{vignette("DepInfeR")}.

All software-related questions should be posted to the Bioconductor Support Site:

\url{https://support.bioconductor.org}

The code can be viewed at the GitHub repository.
\url{https://github.com/Huber-group-EMBL/DepInfeR}
}
\references{
Batzilla, A. and Lu, J. et al. (2022)
Inferring tumor-specific cancer dependencies through integrating ex-vivo 
drug response assays and drug-protein profiling.
\url{https://www.biorxiv.org/content/10.1101/2022.01.11.475864v1}
}
\author{
Alina Batzilla, Junyan Lu
}
\keyword{package}
