% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LazyIndex-class.R
\docType{class}
\name{LazyIndex-class}
\alias{LazyIndex-class}
\alias{.LazyIndex}
\alias{LazyIndex}
\alias{cbind,LazyIndex-method}
\alias{[,LazyIndex,ANY,ANY,ANY-method}
\alias{[,LazyIndex-method}
\title{The \code{LazyIndex} class and methods.}
\usage{
LazyIndex(listData = list(), index = integer())

\S4method{cbind}{LazyIndex}(..., deparse.level = 1)

\S4method{[}{LazyIndex,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{listData}{the list data for all mapping indexes that are used in
corresponding \code{DelayedDataFrame} object.}

\item{index}{the position of mapping indexes in \code{listData} for
each column of the corresponding \code{DelayedDataFrame}
object.}

\item{...}{\code{LazyIndex} objects.}

\item{deparse.level}{See \code{?base::cbind} for a description of
this argument.}

\item{x}{\code{LazyIndex} object.}

\item{i}{row subscript for \code{LazyIndex}, which will subset the
\code{listData} slot.}

\item{j}{column subscript for \code{LazyIndex}, which will subset
the \code{index} slot.}

\item{drop}{Logical. Wheter to drop the dimension if any of the
dimensions has length 1. Default is TRUE.}
}
\value{
a \code{LazyIndex} object.
}
\description{
The \code{LazyIndex} class is designed to carry
    mapping indexes for \code{DelayedDataFrame} columns. So that
    some operations (e.g., subsetting) on \code{DelayedDataFrame}
    are delayed until a realization call is incurred. (e.g.,
    as.list(), DataFrame(), ...)

\code{LazyIndex} constructor.

the subsetting method for \code{LazyIndex} object.
}
\details{
the \code{cbind,LazyIndex} method is defined to bind the
    LazyIndexes column-wise when \code{cbind,DelayedDataFrame}
    function is called.
}
