% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCrePlotFuns.R
\name{getDistBinNullAssocProb}
\alias{getDistBinNullAssocProb}
\title{Calculate Null Association Probability for Each Distance Bin}
\usage{
getDistBinNullAssocProb(degCreResList)
}
\arguments{
\item{degCreResList}{A list of DegCre results.}
}
\value{
A matrix with these columns:
\describe{
  \item{binAssocDist}{Numeric value representing the distance bin
  (TSS to CRE) in base pairs.}
  \item{nullAssocProb}{Numeric value representing the null association
  probability of the bin.}
}
}
\description{
Calculates the null association probability for each distance bin in the
DegCre analysis.
}
\details{
This function takes the results of the DegCre analysis and computes the null
association probability for each unique distance bin. The null association
probability represents the expected proportion of differentially expressed
genes (DEGs) in each distance bin under the null hypothesis.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load example data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

# Calculate null association probabilities.
outNullMat <- getDistBinNullAssocProb(degCreResList = degCreResListDexNR3C1)

}
\author{
Brian S. Roberts
}
